/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.light;

import com.simibubi.create.foundation.render.backend.RenderUtil;
import com.simibubi.create.foundation.render.backend.light.CoordinateConsumer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;

public class GridAlignedBB {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public GridAlignedBB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public static GridAlignedBB ofRadius(int radius) {
        return new GridAlignedBB(-radius, -radius, -radius, radius + 1, radius + 1, radius + 1);
    }

    public static GridAlignedBB copy(GridAlignedBB bb) {
        return new GridAlignedBB(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
    }

    public static GridAlignedBB from(AxisAlignedBB aabb) {
        int minX = (int)Math.floor(aabb.field_72340_a);
        int minY = (int)Math.floor(aabb.field_72338_b);
        int minZ = (int)Math.floor(aabb.field_72339_c);
        int maxX = (int)Math.ceil(aabb.field_72336_d);
        int maxY = (int)Math.ceil(aabb.field_72337_e);
        int maxZ = (int)Math.ceil(aabb.field_72334_f);
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static GridAlignedBB from(SectionPos pos) {
        return new GridAlignedBB(pos.func_218161_d(), pos.func_218151_e(), pos.func_218164_f(), pos.func_218152_g() + 1, pos.func_218165_h() + 1, pos.func_218143_r() + 1);
    }

    public static GridAlignedBB from(BlockPos start, BlockPos end) {
        return new GridAlignedBB(start.func_177958_n(), start.func_177956_o(), start.func_177952_p(), end.func_177958_n() + 1, end.func_177956_o() + 1, end.func_177952_p() + 1);
    }

    public static GridAlignedBB from(int sectionX, int sectionZ) {
        int startX = sectionX << 4;
        int startZ = sectionZ << 4;
        return new GridAlignedBB(startX, 0, startZ, startX + 16, 256, startZ + 16);
    }

    public static AxisAlignedBB toAABB(GridAlignedBB bb) {
        return new AxisAlignedBB((double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ);
    }

    public GridAlignedBB copy() {
        return GridAlignedBB.copy(this);
    }

    public boolean sameAs(GridAlignedBB other) {
        return this.minX == other.minX && this.minY == other.minY && this.minZ == other.minZ && this.maxX == other.maxX && this.maxY == other.maxY && this.maxZ == other.maxZ;
    }

    public void fixMinMax() {
        int minX = Math.min(this.minX, this.maxX);
        int minY = Math.min(this.minY, this.maxY);
        int minZ = Math.min(this.minZ, this.maxZ);
        int maxX = Math.max(this.minX, this.maxX);
        int maxY = Math.max(this.minY, this.maxY);
        int maxZ = Math.max(this.minZ, this.maxZ);
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public int sizeX() {
        return this.maxX - this.minX;
    }

    public int sizeY() {
        return this.maxY - this.minY;
    }

    public int sizeZ() {
        return this.maxZ - this.minZ;
    }

    public int volume() {
        return this.sizeX() * this.sizeY() * this.sizeZ();
    }

    public boolean empty() {
        return this.minX == this.maxX || this.minY == this.maxY || this.minZ == this.maxZ;
    }

    public void translate(Vector3i by) {
        this.translate(by.func_177958_n(), by.func_177956_o(), by.func_177952_p());
    }

    public void translate(int x, int y, int z) {
        this.minX += x;
        this.maxX += x;
        this.minY += y;
        this.maxY += y;
        this.minZ += z;
        this.maxZ += z;
    }

    public void mirrorAbout(Direction.Axis axis) {
        Vector3i axisVec = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).func_176730_m();
        int flipX = axisVec.func_177958_n() - 1;
        int flipY = axisVec.func_177956_o() - 1;
        int flipZ = axisVec.func_177952_p() - 1;
        int maxX = this.maxX * flipX;
        int maxY = this.maxY * flipY;
        int maxZ = this.maxZ * flipZ;
        this.maxX = this.minX * flipX;
        this.maxY = this.minY * flipY;
        this.maxZ = this.minZ * flipZ;
        this.minX = maxX;
        this.minY = maxY;
        this.minZ = maxZ;
    }

    public void nextPowerOf2Centered() {
        int sizeX = this.sizeX();
        int sizeY = this.sizeY();
        int sizeZ = this.sizeZ();
        int newSizeX = RenderUtil.nextPowerOf2(sizeX);
        int newSizeY = RenderUtil.nextPowerOf2(sizeY);
        int newSizeZ = RenderUtil.nextPowerOf2(sizeZ);
        int diffX = newSizeX - sizeX;
        int diffY = newSizeY - sizeY;
        int diffZ = newSizeZ - sizeZ;
        this.minX -= diffX / 2;
        this.minY -= diffY / 2;
        this.minZ -= diffZ / 2;
        this.maxX += (diffX + 1) / 2;
        this.maxY += (diffY + 1) / 2;
        this.maxZ += (diffZ + 1) / 2;
    }

    public void nextPowerOf2() {
        int sizeX = RenderUtil.nextPowerOf2(this.sizeX());
        int sizeY = RenderUtil.nextPowerOf2(this.sizeY());
        int sizeZ = RenderUtil.nextPowerOf2(this.sizeZ());
        this.maxX = this.minX + sizeX;
        this.maxY = this.minY + sizeY;
        this.maxZ = this.minZ + sizeZ;
    }

    public boolean hasPowerOf2Sides() {
        return RenderUtil.isPowerOf2(this.volume());
    }

    public void grow(int s) {
        this.grow(s, s, s);
    }

    public void grow(int x, int y, int z) {
        this.minX -= x;
        this.minY -= y;
        this.minZ -= z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
    }

    public GridAlignedBB intersect(GridAlignedBB other) {
        int minX = Math.max(this.minX, other.minX);
        int minY = Math.max(this.minY, other.minY);
        int minZ = Math.max(this.minZ, other.minZ);
        int maxX = Math.min(this.maxX, other.maxX);
        int maxY = Math.min(this.maxY, other.maxY);
        int maxZ = Math.min(this.maxZ, other.maxZ);
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void intersectAssign(GridAlignedBB other) {
        this.minX = Math.max(this.minX, other.minX);
        this.minY = Math.max(this.minY, other.minY);
        this.minZ = Math.max(this.minZ, other.minZ);
        this.maxX = Math.min(this.maxX, other.maxX);
        this.maxY = Math.min(this.maxY, other.maxY);
        this.maxZ = Math.min(this.maxZ, other.maxZ);
    }

    public GridAlignedBB union(GridAlignedBB other) {
        int minX = Math.min(this.minX, other.minX);
        int minY = Math.min(this.minY, other.minY);
        int minZ = Math.min(this.minZ, other.minZ);
        int maxX = Math.max(this.maxX, other.maxX);
        int maxY = Math.max(this.maxY, other.maxY);
        int maxZ = Math.max(this.maxZ, other.maxZ);
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void unionAssign(GridAlignedBB other) {
        this.minX = Math.min(this.minX, other.minX);
        this.minY = Math.min(this.minY, other.minY);
        this.minZ = Math.min(this.minZ, other.minZ);
        this.maxX = Math.max(this.maxX, other.maxX);
        this.maxY = Math.max(this.maxY, other.maxY);
        this.maxZ = Math.max(this.maxZ, other.maxZ);
    }

    public void unionAssign(AxisAlignedBB other) {
        this.minX = Math.min(this.minX, (int)Math.floor(other.field_72340_a));
        this.minY = Math.min(this.minY, (int)Math.floor(other.field_72338_b));
        this.minZ = Math.min(this.minZ, (int)Math.floor(other.field_72339_c));
        this.maxX = Math.max(this.maxX, (int)Math.ceil(other.field_72336_d));
        this.maxY = Math.max(this.maxY, (int)Math.ceil(other.field_72337_e));
        this.maxZ = Math.max(this.maxZ, (int)Math.ceil(other.field_72334_f));
    }

    public boolean intersects(GridAlignedBB other) {
        return this.intersects(other.minX, other.minY, other.minZ, other.maxX, other.maxY, other.maxZ);
    }

    public boolean contains(GridAlignedBB other) {
        return other.minX >= this.minX && other.maxX <= this.maxX && other.minY >= this.minY && other.maxY <= this.maxY && other.minZ >= this.minZ && other.maxZ <= this.maxZ;
    }

    public boolean isContainedBy(GridAlignedBB other) {
        return other.contains(this);
    }

    public boolean intersects(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.minX < maxX && this.maxX > minX && this.minY < maxY && this.maxY > minY && this.minZ < maxZ && this.maxZ > minZ;
    }

    public void forEachContained(CoordinateConsumer func) {
        if (this.empty()) {
            return;
        }
        for (int x = this.minX; x < this.maxX; ++x) {
            for (int y = Math.max(this.minY, 0); y < Math.min(this.maxY, 255); ++y) {
                for (int z = this.minZ; z < this.maxZ; ++z) {
                    func.consume(x, y, z);
                }
            }
        }
    }

    public AxisAlignedBB toAABB() {
        return GridAlignedBB.toAABB(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridAlignedBB that = (GridAlignedBB)o;
        return this.sameAs(that);
    }

    public int hashCode() {
        int result = this.minX;
        result = 31 * result + this.minY;
        result = 31 * result + this.minZ;
        result = 31 * result + this.maxX;
        result = 31 * result + this.maxY;
        result = 31 * result + this.maxZ;
        return result;
    }
}

