/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.light;

import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.RenderWork;
import com.simibubi.create.foundation.render.backend.gl.GlTexture;
import com.simibubi.create.foundation.render.backend.gl.versioned.RGPixelFormat;
import com.simibubi.create.foundation.render.backend.light.GridAlignedBB;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryUtil;

public class LightVolume {
    private GridAlignedBB sampleVolume;
    private GridAlignedBB textureVolume;
    private ByteBuffer lightData;
    private boolean bufferDirty;
    private boolean removed;
    private final GlTexture glTexture;
    private final RGPixelFormat pixelFormat;

    public LightVolume(GridAlignedBB sampleVolume) {
        this.setSampleVolume(sampleVolume);
        this.pixelFormat = Backend.compat.pixelFormat;
        this.glTexture = new GlTexture(32879);
        this.lightData = MemoryUtil.memAlloc((int)(this.textureVolume.volume() * this.pixelFormat.byteCount()));
        GL20.glActiveTexture((int)33988);
        this.glTexture.bind();
        int sizeX = this.textureVolume.sizeX();
        int sizeY = this.textureVolume.sizeY();
        int sizeZ = this.textureVolume.sizeZ();
        GL12.glTexImage3D((int)32879, (int)0, (int)this.pixelFormat.internalFormat(), (int)sizeX, (int)sizeY, (int)sizeZ, (int)0, (int)this.pixelFormat.format(), (int)5121, (long)0L);
        this.glTexture.unbind();
        GL20.glActiveTexture((int)33984);
    }

    private void setSampleVolume(GridAlignedBB sampleVolume) {
        this.sampleVolume = sampleVolume;
        this.textureVolume = sampleVolume.copy();
        this.textureVolume.nextPowerOf2Centered();
    }

    public GridAlignedBB getTextureVolume() {
        return GridAlignedBB.copy(this.textureVolume);
    }

    public GridAlignedBB getSampleVolume() {
        return GridAlignedBB.copy(this.sampleVolume);
    }

    public int getMinX() {
        return this.textureVolume.minX;
    }

    public int getMinY() {
        return this.textureVolume.minY;
    }

    public int getMinZ() {
        return this.textureVolume.minZ;
    }

    public int getMaxX() {
        return this.textureVolume.maxX;
    }

    public int getMaxY() {
        return this.textureVolume.maxY;
    }

    public int getMaxZ() {
        return this.textureVolume.maxZ;
    }

    public int getSizeX() {
        return this.textureVolume.sizeX();
    }

    public int getSizeY() {
        return this.textureVolume.sizeY();
    }

    public int getSizeZ() {
        return this.textureVolume.sizeZ();
    }

    public void move(IBlockDisplayReader world, GridAlignedBB newSampleVolume) {
        if (this.textureVolume.contains(newSampleVolume)) {
            if (newSampleVolume.intersects(this.sampleVolume)) {
                GridAlignedBB newArea = newSampleVolume.intersect(this.sampleVolume);
                this.sampleVolume = newSampleVolume;
                this.copyLight(world, newArea);
            } else {
                this.sampleVolume = newSampleVolume;
                this.initialize(world);
            }
        } else {
            this.setSampleVolume(newSampleVolume);
            int volume = this.textureVolume.volume();
            if (volume * 2 > this.lightData.capacity()) {
                this.lightData = MemoryUtil.memRealloc((ByteBuffer)this.lightData, (int)(volume * 2));
            }
            this.initialize(world);
        }
    }

    public void notifyLightUpdate(IBlockDisplayReader world, LightType type, GridAlignedBB changedVolume) {
        if (this.removed) {
            return;
        }
        if (!changedVolume.intersects(this.sampleVolume)) {
            return;
        }
        changedVolume = changedVolume.intersect(this.sampleVolume);
        if (type == LightType.BLOCK) {
            this.copyBlock(world, changedVolume);
        } else if (type == LightType.SKY) {
            this.copySky(world, changedVolume);
        }
    }

    public void notifyLightPacket(IBlockDisplayReader world, int chunkX, int chunkZ) {
        if (this.removed) {
            return;
        }
        GridAlignedBB changedVolume = GridAlignedBB.from(chunkX, chunkZ);
        if (!changedVolume.intersects(this.sampleVolume)) {
            return;
        }
        changedVolume.intersectAssign(this.sampleVolume);
        this.copyLight(world, changedVolume);
    }

    public void initialize(IBlockDisplayReader world) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int shiftX = this.textureVolume.minX;
        int shiftY = this.textureVolume.minY;
        int shiftZ = this.textureVolume.minZ;
        this.sampleVolume.forEachContained((x, y, z) -> {
            pos.func_181079_c(x, y, z);
            int blockLight = world.func_226658_a_(LightType.BLOCK, (BlockPos)pos);
            int skyLight = world.func_226658_a_(LightType.SKY, (BlockPos)pos);
            this.writeLight(x - shiftX, y - shiftY, z - shiftZ, blockLight, skyLight);
        });
        this.bufferDirty = true;
    }

    public void copyBlock(IBlockDisplayReader world, GridAlignedBB worldVolume) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int xShift = this.textureVolume.minX;
        int yShift = this.textureVolume.minY;
        int zShift = this.textureVolume.minZ;
        worldVolume.forEachContained((x, y, z) -> {
            pos.func_181079_c(x, y, z);
            int light = world.func_226658_a_(LightType.BLOCK, (BlockPos)pos);
            this.writeBlock(x - xShift, y - yShift, z - zShift, light);
        });
        this.bufferDirty = true;
    }

    public void copySky(IBlockDisplayReader world, GridAlignedBB worldVolume) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int xShift = this.textureVolume.minX;
        int yShift = this.textureVolume.minY;
        int zShift = this.textureVolume.minZ;
        worldVolume.forEachContained((x, y, z) -> {
            pos.func_181079_c(x, y, z);
            int light = world.func_226658_a_(LightType.SKY, (BlockPos)pos);
            this.writeSky(x - xShift, y - yShift, z - zShift, light);
        });
        this.bufferDirty = true;
    }

    public void copyLight(IBlockDisplayReader world, GridAlignedBB worldVolume) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int xShift = this.textureVolume.minX;
        int yShift = this.textureVolume.minY;
        int zShift = this.textureVolume.minZ;
        worldVolume.forEachContained((x, y, z) -> {
            pos.func_181079_c(x, y, z);
            int block = world.func_226658_a_(LightType.BLOCK, (BlockPos)pos);
            int sky = world.func_226658_a_(LightType.SKY, (BlockPos)pos);
            this.writeLight(x - xShift, y - yShift, z - zShift, block, sky);
        });
        this.bufferDirty = true;
    }

    public void bind() {
        if (this.lightData == null || this.removed) {
            return;
        }
        GL13.glActiveTexture((int)33988);
        this.glTexture.bind();
        GL11.glTexParameteri((int)32879, (int)10241, (int)9729);
        GL11.glTexParameteri((int)32879, (int)10240, (int)9729);
        GL11.glTexParameteri((int)32879, (int)10242, (int)33648);
        GL11.glTexParameteri((int)32879, (int)32882, (int)33648);
        GL11.glTexParameteri((int)32879, (int)10243, (int)33648);
        this.uploadTexture();
    }

    private void uploadTexture() {
        if (this.bufferDirty) {
            GL20.glPixelStorei((int)3314, (int)0);
            GL20.glPixelStorei((int)3316, (int)0);
            GL20.glPixelStorei((int)3315, (int)0);
            GL20.glPixelStorei((int)32877, (int)0);
            GL20.glPixelStorei((int)32878, (int)0);
            GL20.glPixelStorei((int)3317, (int)2);
            int sizeX = this.textureVolume.sizeX();
            int sizeY = this.textureVolume.sizeY();
            int sizeZ = this.textureVolume.sizeZ();
            GL12.glTexSubImage3D((int)32879, (int)0, (int)0, (int)0, (int)0, (int)sizeX, (int)sizeY, (int)sizeZ, (int)this.pixelFormat.format(), (int)5121, (ByteBuffer)this.lightData);
            GL20.glPixelStorei((int)3317, (int)4);
            this.bufferDirty = false;
        }
    }

    public void unbind() {
        this.glTexture.unbind();
    }

    public void delete() {
        this.removed = true;
        RenderWork.enqueue(() -> {
            this.glTexture.delete();
            MemoryUtil.memFree((Buffer)this.lightData);
            this.lightData = null;
        });
    }

    private void writeLight(int x, int y, int z, int block, int sky) {
        byte b = (byte)((block & 0xF) << 4);
        byte s = (byte)((sky & 0xF) << 4);
        int i = this.posToIndex(x, y, z);
        this.lightData.put(i, b);
        this.lightData.put(i + 1, s);
    }

    private void writeBlock(int x, int y, int z, int block) {
        byte b = (byte)((block & 0xF) << 4);
        this.lightData.put(this.posToIndex(x, y, z), b);
    }

    private void writeSky(int x, int y, int z, int sky) {
        byte b = (byte)((sky & 0xF) << 4);
        this.lightData.put(this.posToIndex(x, y, z) + 1, b);
    }

    private int posToIndex(int x, int y, int z) {
        return (x + this.textureVolume.sizeX() * (y + z * this.textureVolume.sizeY())) * this.pixelFormat.byteCount();
    }
}

