/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class UniqueLinkedList<E>
extends LinkedList<E> {
    private final HashSet<E> contained = new HashSet();

    @Override
    public boolean contains(Object o) {
        return this.contained.contains(o);
    }

    @Override
    public E poll() {
        Object e = super.poll();
        this.contained.remove(e);
        return e;
    }

    @Override
    public boolean add(E e) {
        if (this.contained.add(e)) {
            return super.add(e);
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        if (this.contained.add(element)) {
            super.add(index, element);
        }
    }

    @Override
    public void addFirst(E e) {
        if (this.contained.add(e)) {
            super.addFirst(e);
        }
    }

    @Override
    public void addLast(E e) {
        if (this.contained.add(e)) {
            super.addLast(e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        List filtered = c.stream().filter(it -> !this.contained.contains(it)).collect(Collectors.toList());
        return super.addAll(filtered);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        List filtered = c.stream().filter(it -> !this.contained.contains(it)).collect(Collectors.toList());
        return super.addAll(index, filtered);
    }

    @Override
    public boolean remove(Object o) {
        this.contained.remove(o);
        return super.remove(o);
    }

    @Override
    public E remove(int index) {
        Object e = super.remove(index);
        this.contained.remove(e);
        return e;
    }

    @Override
    public E removeFirst() {
        Object e = super.removeFirst();
        this.contained.remove(e);
        return e;
    }

    @Override
    public E removeLast() {
        Object e = super.removeLast();
        this.contained.remove(e);
        return e;
    }

    @Override
    public void clear() {
        super.clear();
        this.contained.clear();
    }
}

