/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.repack.registrate.builders;

import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.builders.AbstractBuilder;
import com.simibubi.create.repack.registrate.builders.BuilderCallback;
import com.simibubi.create.repack.registrate.util.nullness.NonnullType;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;

public class EnchantmentBuilder<T extends Enchantment, P>
extends AbstractBuilder<Enchantment, T, P, EnchantmentBuilder<T, P>> {
    private Enchantment.Rarity rarity = Enchantment.Rarity.COMMON;
    private final EnchantmentType type;
    private EnumSet<EquipmentSlotType> slots = EnumSet.noneOf(EquipmentSlotType.class);
    private final EnchantmentFactory<T> factory;

    public static <T extends Enchantment, P> EnchantmentBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EnchantmentType type, EnchantmentFactory<T> factory) {
        return new EnchantmentBuilder<T, P>(owner, parent, name, callback, type, factory).defaultLang();
    }

    protected EnchantmentBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EnchantmentType type, EnchantmentFactory<T> factory) {
        super(owner, parent, name, callback, Enchantment.class);
        this.factory = factory;
        this.type = type;
    }

    public EnchantmentBuilder<T, P> rarity(Enchantment.Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnchantmentBuilder<T, P> addArmorSlots() {
        return this.addSlots(EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET);
    }

    public EnchantmentBuilder<T, P> addSlots(EquipmentSlotType ... slots) {
        this.slots.addAll(Arrays.asList(slots));
        return this;
    }

    public EnchantmentBuilder<T, P> defaultLang() {
        return (EnchantmentBuilder)this.lang(Enchantment::func_77320_a);
    }

    public EnchantmentBuilder<T, P> lang(String name) {
        return (EnchantmentBuilder)this.lang(Enchantment::func_77320_a, name);
    }

    @Override
    @NonnullType
    protected T createEntry() {
        return this.factory.create(this.rarity, this.type, this.slots.toArray(new EquipmentSlotType[0]));
    }

    @FunctionalInterface
    public static interface EnchantmentFactory<T extends Enchantment> {
        public T create(Enchantment.Rarity var1, EnchantmentType var2, EquipmentSlotType ... var3);
    }
}

