/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.asm;

import com.fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import com.fuzs.pickupnotifier.client.gui.entry.ExperienceDisplayEntry;
import com.fuzs.pickupnotifier.client.gui.entry.ItemDisplayEntry;
import com.fuzs.pickupnotifier.client.handler.DrawEntriesHandler;
import com.fuzs.pickupnotifier.config.ConfigValueHolder;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class AddEntriesHandler {
    public static void onEntityPickup(Entity entity, Entity livingentity) {
        if (livingentity == Minecraft.func_71410_x().field_71439_g) {
            if (entity instanceof ItemEntity) {
                AddEntriesHandler.addItemEntry(((ItemEntity)entity).func_92059_d());
            } else if (entity instanceof ArrowEntity) {
                AddEntriesHandler.addItemEntry(new ItemStack((IItemProvider)Items.field_151032_g));
            } else if (entity instanceof SpectralArrowEntity) {
                AddEntriesHandler.addItemEntry(new ItemStack((IItemProvider)Items.field_185166_h));
            } else if (entity instanceof TridentEntity) {
                AddEntriesHandler.addItemEntry(new ItemStack((IItemProvider)Items.field_203184_eO));
            } else if (entity instanceof ExperienceOrbEntity) {
                AddEntriesHandler.addExperienceEntry((ExperienceOrbEntity)entity);
            }
        }
    }

    private static void addItemEntry(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_190916_E() > 0 && !ConfigValueHolder.getGeneralConfig().blacklist.contains(stack.func_77973_b())) {
            stack = stack.func_77946_l();
            stack.func_196083_e("Enchantments");
            AddEntriesHandler.addEntry(new ItemDisplayEntry(stack));
        }
    }

    private static void addExperienceEntry(ExperienceOrbEntity orb) {
        if (ConfigValueHolder.getGeneralConfig().displayExperience && orb.field_70530_e > 0) {
            AddEntriesHandler.addEntry(new ExperienceDisplayEntry(orb));
        }
    }

    private static void addEntry(DisplayEntry entry) {
        Optional duplicateOptional;
        float scale = (float)ConfigValueHolder.getDisplayConfig().scale / 6.0f;
        int scaledHeight = (int)((float)Minecraft.func_71410_x().func_228018_at_().func_198087_p() / scale);
        int maxSize = (int)((double)scaledHeight * ConfigValueHolder.getDisplayConfig().height / 18.0) - 1;
        Optional<Object> optional = duplicateOptional = ConfigValueHolder.getGeneralConfig().combineEntries ? DrawEntriesHandler.PICK_UPS.findDuplicate(entry) : Optional.empty();
        if (duplicateOptional.isPresent()) {
            DisplayEntry duplicate = (DisplayEntry)duplicateOptional.get();
            duplicate.merge(entry);
            DrawEntriesHandler.PICK_UPS.refresh(duplicate);
        } else {
            DrawEntriesHandler.PICK_UPS.add(entry, maxSize);
        }
    }
}

