/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.fog;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.fog.FogResult;
import org.orecruncher.environs.fog.VanillaFogRangeCalculator;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;
import org.orecruncher.lib.seasons.Season;

@OnlyIn(value=Dist.CLIENT)
public class MorningFogRangeCalculator
extends VanillaFogRangeCalculator {
    private static final float START = 0.63f;
    private static final float END = 0.83f;
    private static final float RESERVE = 10.0f;
    private static final Map<Season, FogType> MAPPING = new Reference2ReferenceOpenHashMap();
    protected final FogResult cache = new FogResult();
    protected int fogDay = -1;
    protected FogType type = FogType.NORMAL;

    public MorningFogRangeCalculator() {
        super("MorningFogRangeCalculator");
    }

    @Override
    public boolean enabled() {
        return (Boolean)Config.CLIENT.fog.enableMorningFog.get();
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        float ca;
        this.cache.set(event);
        if (this.type != FogType.NONE && this.cache.getStart() > this.type.getReserve() && (ca = GameUtils.getWorld().func_242415_f((float)event.getRenderPartialTicks())) >= this.type.getStart() && ca <= this.type.getEnd()) {
            float mid = (this.type.getStart() + this.type.getEnd()) / 2.0f;
            float factor = 1.0f - MathStuff.abs(ca - mid) / (mid - this.type.getStart());
            float shift = this.cache.getStart() * factor;
            float newEnd = this.cache.getEnd() - shift;
            float newStart = MathStuff.clamp(this.cache.getStart() - shift * 2.0f, this.type.getReserve() + 1.0f, newEnd);
            this.cache.set(newStart, newEnd);
        }
        return this.cache;
    }

    @Override
    public void tick() {
        int day = CommonState.getClock().getDay();
        if (this.fogDay != day) {
            int dim = CommonState.getDimensionId();
            int morningFogChance = (Integer)Config.CLIENT.fog.morningFogChance.get();
            this.fogDay = day;
            boolean doFog = dim != -1 && dim != 1 && (morningFogChance < 2 || XorShiftRandom.current().nextInt(morningFogChance) == 0);
            this.type = doFog ? this.getFogType() : FogType.NONE;
        }
    }

    @Nonnull
    protected FogType getFogType() {
        FogType type;
        Season season = CommonState.getSeason();
        if (season != Season.NONE && (type = MAPPING.get((Object)season)) != null) {
            return type;
        }
        return FogType.NORMAL;
    }

    static {
        MAPPING.put(Season.EARLY_AUTUMN, FogType.NORMAL);
        MAPPING.put(Season.MID_AUTUMN, FogType.MEDIUM);
        MAPPING.put(Season.LATE_AUTUMN, FogType.HEAVY);
        MAPPING.put(Season.EARLY_WINTER, FogType.MEDIUM);
        MAPPING.put(Season.MID_WINTER, FogType.LIGHT);
        MAPPING.put(Season.LATE_WINTER, FogType.NORMAL);
        MAPPING.put(Season.EARLY_SPRING, FogType.MEDIUM);
        MAPPING.put(Season.MID_SPRING, FogType.HEAVY);
        MAPPING.put(Season.LATE_SPRING, FogType.NORMAL);
        MAPPING.put(Season.EARLY_SUMMER, FogType.LIGHT);
        MAPPING.put(Season.MID_SUMMER, FogType.NONE);
        MAPPING.put(Season.LATE_SUMMER, FogType.LIGHT);
    }

    public static enum FogType {
        NONE(0.0f, 0.0f, 0.0f),
        NORMAL(0.63f, 0.83f, 10.0f),
        LIGHT(0.73f, 0.72999996f, 15.0f),
        MEDIUM(0.53f, 0.93f, 10.0f),
        HEAVY(0.53f, 1.03f, 5.0f);

        private final float start;
        private final float end;
        private final float reserve;

        private FogType(float start, float end, float reserve) {
            this.start = start;
            this.end = end;
            this.reserve = reserve;
        }

        public float getStart() {
            return this.start;
        }

        public float getEnd() {
            return this.end;
        }

        public float getReserve() {
            return this.reserve;
        }
    }
}

