/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers.scripts;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.util.StringUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.handlers.scripts.StateVariables;
import org.orecruncher.lib.scripting.ExecutionContext;
import org.orecruncher.lib.scripting.sets.BiomeVariables;
import org.orecruncher.lib.scripting.sets.DimensionVariables;
import org.orecruncher.lib.scripting.sets.DiurnalCycleVariables;
import org.orecruncher.lib.scripting.sets.PlayerVariables;
import org.orecruncher.lib.scripting.sets.SeasonVariables;
import org.orecruncher.lib.scripting.sets.WeatherVariables;

@OnlyIn(value=Dist.CLIENT)
public final class ConditionEvaluator {
    public static final ConditionEvaluator INSTANCE = new ConditionEvaluator();
    private final ExecutionContext context = new ExecutionContext("Conditions");

    private ConditionEvaluator() {
        this.context.add(new BiomeVariables());
        this.context.add(new DimensionVariables());
        this.context.add(new DiurnalCycleVariables());
        this.context.add(new PlayerVariables());
        this.context.add(new WeatherVariables());
        this.context.add(new StateVariables());
        this.context.add(new SeasonVariables());
    }

    public void tick() {
        this.context.update();
    }

    public boolean check(@Nonnull String conditions) {
        Object result = this.eval(conditions);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public Object eval(@Nonnull String conditions) {
        if (StringUtils.func_151246_b((String)conditions)) {
            return true;
        }
        Optional<Object> result = this.context.eval(conditions);
        return result.orElse(false);
    }
}

