/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.library;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.environs.Environs;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.library.DimensionInfo;
import org.orecruncher.environs.library.config.DimensionConfig;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.resource.IResourceAccessor;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.service.IModuleService;
import org.orecruncher.lib.service.ModuleServiceManager;
import org.orecruncher.lib.validation.ListValidator;
import org.orecruncher.lib.validation.Validators;

@OnlyIn(value=Dist.CLIENT)
public final class DimensionLibrary {
    private static final IModLog LOGGER = Environs.LOGGER.createChild(DimensionLibrary.class);
    private static final ObjectArray<DimensionConfig> cache = new ObjectArray();
    private static final HashMap<RegistryKey<World>, DimensionInfo> configs = new HashMap();

    private DimensionLibrary() {
    }

    static void initialize() {
        ModuleServiceManager.instance().add(new DimensionLibraryService());
    }

    static void initFromConfig(@Nonnull List<DimensionConfig> cfg) {
        cfg.forEach(DimensionLibrary::register);
    }

    @Nonnull
    private static DimensionConfig getData(@Nonnull DimensionConfig entry) {
        Optional<DimensionConfig> result = cache.stream().filter(e -> e.equals(entry)).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        cache.add(entry);
        return entry;
    }

    private static void register(@Nonnull DimensionConfig entry) {
        if (entry.dimensionId != null) {
            DimensionConfig data = DimensionLibrary.getData(entry);
            if (data == entry) {
                return;
            }
            if (data.dimensionId == null) {
                data.dimensionId = entry.dimensionId;
            }
            if (entry.hasAurora != null) {
                data.hasAurora = entry.hasAurora;
            }
            if (entry.hasHaze != null) {
                data.hasHaze = entry.hasHaze;
            }
            if (entry.hasWeather != null) {
                data.hasWeather = entry.hasWeather;
            }
            if (entry.cloudHeight != null) {
                data.cloudHeight = entry.cloudHeight;
            }
            if (entry.seaLevel != null) {
                data.seaLevel = entry.seaLevel;
            }
            if (entry.skyHeight != null) {
                data.skyHeight = entry.skyHeight;
            }
        }
    }

    @Nonnull
    public static DimensionInfo getData(@Nonnull World world) {
        RegistryKey key = world.func_234923_W_();
        DimensionInfo dimInfo = configs.get(key);
        if (dimInfo == null) {
            DimensionConfig config = null;
            ResourceLocation location = key.func_240901_a_();
            for (DimensionConfig e : cache) {
                if (!e.dimensionId.equals(location.toString())) continue;
                config = e;
                break;
            }
            dimInfo = new DimensionInfo(world, config);
            configs.put((RegistryKey<World>)key, dimInfo);
        }
        return dimInfo;
    }

    public static Stream<String> dump() {
        return cache.stream().map(Object::toString).sorted();
    }

    private static class DimensionLibraryService
    implements IModuleService {
        private static final Type dimensionType = TypeToken.getParameterized(List.class, (Type[])new Type[]{DimensionConfig.class}).getType();

        private DimensionLibraryService() {
        }

        @Override
        public String name() {
            return "DimensionLibrary";
        }

        @Override
        public void start() {
            Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "dimensions.json");
            IResourceAccessor.process(configs, accessor -> DimensionLibrary.initFromConfig((List)accessor.as(dimensionType)));
        }

        @Override
        public void log() {
            if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
                LOGGER.info("*** DIMENSION REGISTRY (cache) ***", new Object[0]);
                DimensionLibrary.dump().forEach(arg_0 -> DimensionLibraryService.lambda$log$1(LOGGER, arg_0));
            }
        }

        @Override
        public void stop() {
            cache.clear();
            configs.clear();
        }

        private static /* synthetic */ void lambda$log$1(IModLog rec$, String x$0) {
            rec$.info(x$0, new Object[0]);
        }

        static {
            Validators.registerValidator(dimensionType, new ListValidator());
        }
    }
}

