/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.scanner;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.library.DimensionInfo;
import org.orecruncher.environs.library.DimensionLibrary;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.math.MathStuff;

@OnlyIn(value=Dist.CLIENT)
public final class CeilingCoverage {
    private static final int SURVEY_INTERVAL = 4;
    private static final int INSIDE_SURVEY_RANGE = 3;
    private static final float INSIDE_THRESHOLD = 0.6306818f;
    private static final Cell[] cells;
    private static final float TOTAL_POINTS;
    private static final ObjectArray<ITag<Block>> NON_CEILING;
    private boolean reallyInside = false;

    public void tick() {
        if (TickCounter.getTickCount() % 4L == 0L) {
            DimensionInfo dimInfo = DimensionLibrary.getData((World)GameUtils.getWorld());
            if (dimInfo.alwaysOutside()) {
                this.reallyInside = false;
            } else {
                BlockPos pos = CommonState.getPlayerPosition();
                float score = 0.0f;
                for (Cell cell : cells) {
                    score += cell.score(pos);
                }
                float ceilingCoverageRatio = 1.0f - score / TOTAL_POINTS;
                this.reallyInside = ceilingCoverageRatio > 0.6306818f;
            }
        }
    }

    public boolean isReallyInside() {
        return this.reallyInside;
    }

    static {
        NON_CEILING = new ObjectArray();
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                cellList.add(new Cell(new Vector3i(x, 0, z), 3));
            }
        }
        Collections.sort(cellList);
        cells = cellList.toArray(new Cell[0]);
        float totalPoints = 0.0f;
        for (Cell c : cellList) {
            totalPoints += c.potentialPoints();
        }
        TOTAL_POINTS = totalPoints;
        NON_CEILING.add((ITag<Block>)BlockTags.field_206952_E);
        NON_CEILING.add((ITag<Block>)BlockTags.field_232868_aA_);
        NON_CEILING.add((ITag<Block>)BlockTags.field_219748_G);
        NON_CEILING.add((ITag<Block>)BlockTags.field_219757_z);
        NON_CEILING.add((ITag<Block>)Tags.Blocks.GLASS_PANES);
        NON_CEILING.add((ITag<Block>)Tags.Blocks.CHESTS);
        NON_CEILING.add((ITag<Block>)Tags.Blocks.FENCES);
        NON_CEILING.add((ITag<Block>)Tags.Blocks.FENCE_GATES);
    }

    private static final class Cell
    implements Comparable<Cell> {
        private final Vector3i offset;
        private final float points;
        private final BlockPos.Mutable working;

        public Cell(@Nonnull Vector3i offset, int range) {
            this.offset = offset;
            float xV = range - MathStuff.abs(offset.func_177958_n()) + 1;
            float zV = range - MathStuff.abs(offset.func_177952_p()) + 1;
            float candidate = Math.min(xV, zV);
            this.points = candidate * candidate;
            this.working = new BlockPos.Mutable();
        }

        public float potentialPoints() {
            return this.points;
        }

        public float score(@Nonnull BlockPos playerPos) {
            this.working.func_181079_c(playerPos.func_177958_n() + this.offset.func_177958_n(), playerPos.func_177956_o() + this.offset.func_177956_o(), playerPos.func_177952_p() + this.offset.func_177952_p());
            ClientWorld world = GameUtils.getWorld();
            int playerHeight = Math.max(playerPos.func_177956_o() + 1, 0);
            this.working.func_189533_g((Vector3i)WorldUtils.getPrecipitationHeight((IWorldReader)world, (BlockPos)this.working));
            while (this.working.func_177956_o() > playerHeight) {
                BlockState state = world.func_180495_p((BlockPos)this.working);
                if (this.actsAsCeiling(state)) {
                    return 0.0f;
                }
                this.working.func_185336_p(this.working.func_177956_o() - 1);
            }
            return this.points;
        }

        @Override
        public int compareTo(@Nonnull Cell cell) {
            return -Float.compare(this.potentialPoints(), cell.potentialPoints());
        }

        @Nonnull
        public String toString() {
            return this.offset.toString() + " points: " + this.points;
        }

        private boolean actsAsCeiling(@Nonnull BlockState state) {
            if (!state.func_185904_a().func_76230_c()) {
                return false;
            }
            Block block = state.func_177230_c();
            for (ITag tag : NON_CEILING) {
                if (!tag.func_230235_a_((Object)block)) continue;
                return false;
            }
            return true;
        }
    }
}

