/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.config;

import java.io.File;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.orecruncher.mobeffects.MobEffects;
import org.orecruncher.mobeffects.footsteps.FootprintStyle;

@Mod.EventBusSubscriber(modid="mobeffects", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Config {
    public static final int FOOTSTEP_VOLUME_DEFAULT = 40;
    public static final Client CLIENT;
    private static final String CLIENT_CONFIG;
    public static final ForgeConfigSpec SPEC;

    private Config() {
    }

    private static void applyConfig() {
        MobEffects.LOGGER.setDebug((Boolean)Config.CLIENT.logging.enableLogging.get());
        MobEffects.LOGGER.setTraceMask((Integer)Config.CLIENT.logging.flagMask.get());
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        Config.applyConfig();
        MobEffects.LOGGER.debug("Loaded config file %s", configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        MobEffects.LOGGER.debug("Config file changed %s", configEvent.getConfig().getFileName());
        Config.applyConfig();
    }

    public static void setup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, SPEC, CLIENT_CONFIG);
    }

    static {
        CLIENT_CONFIG = "dsurround" + File.separator + "mobeffects" + "-client.toml";
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final Logging logging;
        public final Footsteps footsteps;
        public final Effects effects;

        Client(@Nonnull ForgeConfigSpec.Builder builder) {
            this.logging = new Logging(builder);
            this.footsteps = new Footsteps(builder);
            this.effects = new Effects(builder);
        }

        public static class Effects {
            public final ForgeConfigSpec.BooleanValue hidePlayerPotionParticles;
            public final ForgeConfigSpec.BooleanValue showBreath;
            public final ForgeConfigSpec.BooleanValue showArrowTrail;
            public final ForgeConfigSpec.BooleanValue enableToolbarEffect;
            public final ForgeConfigSpec.BooleanValue enableBowEffect;
            public final ForgeConfigSpec.BooleanValue enableSwingEffect;
            public final ForgeConfigSpec.IntValue toolbarVolume;

            public Effects(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Options for mob effect generation").push("Mob Effect Options");
                this.hidePlayerPotionParticles = builder.comment("Hides the player's potion particles to avoid cluttering display").translation("mobeffects.cfg.effects.PotionParticles").define("Hide Player Potion Particles", true);
                this.showBreath = builder.worldRestart().comment("Show breath effect in cold regions and underwater").translation("mobeffects.cfg.effects.Breath").define("Show Breath Effect", true);
                this.showArrowTrail = builder.comment("Show arrow particle trail during flight").translation("mobeffects.cfg.effects.Arrow").define("Show Arrow Particle Trail", false);
                this.enableToolbarEffect = builder.worldRestart().comment("Enable toolbar item sound effects").translation("mobeffects.cfg.effects.Toolbar").define("Enable Toolbar Sound Effects", true);
                this.enableBowEffect = builder.worldRestart().comment("Enable bow/crossbow sound effects").translation("mobeffects.cfg.effects.Bow").define("Enable Bow Sound Effects", true);
                this.enableSwingEffect = builder.worldRestart().comment("Enable item swing sound effects").translation("mobeffects.cfg.effects.Swing").define("Enable Item Swing Sound Effects", true);
                this.toolbarVolume = builder.comment("Toolbar master volume scale").translation("mobeffects.cfg.effects.ToolbarVolume").defineInRange("Toolbar Volume Scale", 35, 0, 100);
                builder.pop();
            }
        }

        public static class Footsteps {
            public final ForgeConfigSpec.BooleanValue enableFootstepSounds;
            public final ForgeConfigSpec.BooleanValue enableFootprintParticles;
            public final ForgeConfigSpec.BooleanValue firstPersonFootstepCadence;
            public final ForgeConfigSpec.EnumValue<FootprintStyle> playerFootprintStyle;
            public final ForgeConfigSpec.BooleanValue footstepsAsQuadruped;
            public final ForgeConfigSpec.IntValue footstepVolume;
            public final ForgeConfigSpec.BooleanValue enableArmorAccents;
            public final ForgeConfigSpec.BooleanValue enableRainSplashAccent;
            public final ForgeConfigSpec.BooleanValue enableWaterLoggedAccent;

            public Footsteps(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Defines footstep effect generation parameters").push("Footstep Options");
                this.enableFootstepSounds = builder.comment("Enable replacement of footstep sounds with acoustic versions").translation("mobeffects.cfg.footsteps.SoundEnable").define("Enable Footprint Sound Effects", true);
                this.enableFootprintParticles = builder.comment("Enable Footprint particle effects").translation("mobeffects.cfg.footsteps.Enable").define("Enable Footprint Particles", true);
                this.firstPersonFootstepCadence = builder.comment("Use first person footstep cadence").translation("mobeffects.cfg.footsteps.Cadence").define("First Person Cadence", true);
                this.playerFootprintStyle = builder.comment("Style of footprint to display for a player").translation("mobeffects.cfg.footsteps.PlayerStyle").defineEnum("Player Footprint Style", (Enum)FootprintStyle.LOWRES_SQUARE);
                this.footstepsAsQuadruped = builder.comment("Generate footsteps as a quadruped (horse)").translation("mobeffects.cfg.footsteps.Quadruped").define("Footsteps as Quadruped", false);
                this.footstepVolume = builder.comment("Footstep master volume scale").translation("mobeffects.cfg.footsteps.Volume").defineInRange("Footstep Volume Scale", 40, 0, 100);
                this.enableArmorAccents = builder.comment("Enable armor rustle accents for footstep acoustics").translation("mobeffects.cfg.footsteps.ArmorAccents").define("Enable Armor Accents", true);
                this.enableRainSplashAccent = builder.comment("Enable rain splash accents for footstep acoustics").translation("mobeffects.cfg.footsteps.RainSplashAccents").define("Enable Rain Splash Accents", true);
                this.enableWaterLoggedAccent = builder.comment("Enable water logged accents for footstep acoustics").translation("mobeffects.cfg.footsteps.WaterLoggedAccents").define("Enable Waterlogged Accents", true);
                builder.pop();
            }
        }

        public static class Logging {
            public final ForgeConfigSpec.BooleanValue enableLogging;
            public final ForgeConfigSpec.IntValue flagMask;

            Logging(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Defines how logging will behave").push("Logging Options");
                this.enableLogging = builder.comment("Enables/disables debug logging of the mod").translation("mobeffects.cfg.logging.EnableDebug").define("Debug Logging", false);
                this.flagMask = builder.comment("Bitmask for toggling various debug traces").translation("mobeffects.cfg.logging.FlagMask").defineInRange("Debug Flag Mask", 0, 0, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }
}

