/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.mobeffects.config.Config;
import org.orecruncher.mobeffects.footsteps.Association;
import org.orecruncher.mobeffects.footsteps.FootStrikeLocation;
import org.orecruncher.mobeffects.footsteps.Substrate;
import org.orecruncher.mobeffects.footsteps.facade.FacadeHelper;
import org.orecruncher.mobeffects.library.Constants;
import org.orecruncher.mobeffects.library.FootstepLibrary;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.audio.acoustic.AcousticCompiler;
import org.orecruncher.sndctrl.library.Primitives;

@OnlyIn(value=Dist.CLIENT)
public class AcousticResolver {
    private static final float PROBE_DEPTH = 0.0625f;
    protected final IWorldReader world;
    protected final FootStrikeLocation loc;
    protected final double distanceToCenter;

    public AcousticResolver(@Nonnull IWorldReader world, @Nonnull FootStrikeLocation loc, double distanceToCenter) {
        this.world = world;
        this.loc = loc;
        this.distanceToCenter = distanceToCenter;
    }

    protected BlockState getBlockStateFacade(@Nonnull Vector3d pos) {
        return FacadeHelper.resolveState(this.loc.getEntity(), this.getBlockState(pos), this.world, pos, Direction.UP);
    }

    protected BlockState getBlockState(@Nonnull Vector3d pos) {
        return this.world.func_180495_p(new BlockPos(pos));
    }

    @Nullable
    public Association findAssociation() {
        if (!((Boolean)Config.CLIENT.footsteps.enableFootstepSounds.get()).booleanValue()) {
            return this.findVanillaAssociation();
        }
        Vector3d pos = this.loc.getStrikePosition();
        Association worked = this.resolve(pos);
        if (worked == null) {
            LivingEntity entity = this.loc.getEntity();
            BlockPos adj = new BlockPos(pos);
            double xdang = (entity.func_226277_ct_() - (double)adj.func_177958_n()) * 2.0 - 1.0;
            double zdang = (entity.func_226281_cx_() - (double)adj.func_177952_p()) * 2.0 - 1.0;
            if (Math.max(MathStuff.abs(xdang), MathStuff.abs(zdang)) > this.distanceToCenter) {
                boolean isXdangMax;
                boolean bl = isXdangMax = MathStuff.abs(xdang) > MathStuff.abs(zdang);
                worked = isXdangMax ? this.resolve(xdang > 0.0 ? this.loc.east() : this.loc.west()) : this.resolve(zdang > 0.0 ? this.loc.south() : this.loc.north());
                if (worked == null) {
                    worked = isXdangMax ? this.resolve(zdang > 0.0 ? this.loc.south() : this.loc.north()) : this.resolve(xdang > 0.0 ? this.loc.east() : this.loc.west());
                }
            }
        }
        return worked;
    }

    @Nullable
    protected Association findVanillaAssociation() {
        BlockState state;
        BlockPos blockpos1;
        BlockState blockstate;
        int posZ;
        int posY;
        Vector3d pos = this.loc.getStrikePosition();
        int posX = MathHelper.func_76128_c((double)pos.field_72450_a);
        BlockPos blockpos = new BlockPos(posX, posY = MathHelper.func_76128_c((double)(pos.field_72448_b - 0.0625)), posZ = MathHelper.func_76128_c((double)pos.field_72449_c));
        if (this.world.func_175623_d(blockpos) && (blockstate = this.world.func_180495_p(blockpos1 = blockpos.func_177977_b())).collisionExtendsVertically((IBlockReader)this.world, blockpos1, (Entity)this.loc.getEntity())) {
            blockpos = blockpos1;
        }
        if (!(state = this.world.func_180495_p(blockpos)).func_185904_a().func_76224_d() && !state.isAir((IBlockReader)this.world, blockpos)) {
            blockstate = this.world.func_180495_p(blockpos.func_177984_a());
            SoundType soundtype = blockstate.func_203425_a(Blocks.field_150433_aE) ? blockstate.getSoundType(this.world, blockpos, (Entity)this.loc.getEntity()) : state.getSoundType(this.world, blockpos, (Entity)this.loc.getEntity());
            IAcoustic acoustics = Primitives.getVanillaFootstepAcoustic(soundtype);
            return new Association(this.loc, acoustics);
        }
        return null;
    }

    @Nullable
    protected Association resolve(@Nonnull Vector3d vec) {
        IAcoustic acoustics = Constants.EMPTY;
        Vector3d tPos = vec.func_72441_c(0.0, 1.0, 0.0);
        BlockState above = this.getBlockState(tPos);
        if (above.func_185904_a() != Material.field_151579_a) {
            acoustics = FootstepLibrary.getBlockAcoustics(above, Substrate.CARPET);
        }
        if (acoustics == Constants.NOT_EMITTER || acoustics == Constants.EMPTY) {
            IAcoustic foliage;
            BlockState below;
            BlockState in = this.getBlockStateFacade(vec);
            if (in.func_185904_a() == Material.field_151579_a && (acoustics = FootstepLibrary.getBlockAcoustics(below = this.getBlockState(tPos = vec.func_72441_c(0.0, -1.0, 0.0)), Substrate.FENCE)) != Constants.EMPTY) {
                vec = tPos;
                in = below;
            }
            if (acoustics == Constants.EMPTY) {
                acoustics = FootstepLibrary.getBlockAcoustics(in);
            }
            if (acoustics != Constants.NOT_EMITTER && above.func_185904_a() != Material.field_151579_a && (foliage = FootstepLibrary.getBlockAcoustics(above, Substrate.FOLIAGE)) != Constants.NOT_EMITTER) {
                acoustics = AcousticCompiler.combine(acoustics, foliage);
            }
        } else {
            vec = tPos;
        }
        if (acoustics == Constants.NOT_EMITTER) {
            return null;
        }
        return new Association(this.loc.rebase(new BlockPos(vec)), acoustics);
    }
}

