/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps.accents;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.mobeffects.config.Config;
import org.orecruncher.mobeffects.footsteps.accents.IFootstepAccentProvider;
import org.orecruncher.mobeffects.library.FootstepLibrary;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;

@OnlyIn(value=Dist.CLIENT)
class RainSplashAccent
implements IFootstepAccentProvider {
    RainSplashAccent() {
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.CLIENT.footsteps.enableRainSplashAccent.get();
    }

    @Override
    public void provide(@Nonnull LivingEntity entity, @Nonnull BlockPos blockPos, @Nonnull BlockState posState, @Nonnull ObjectArray<IAcoustic> acoustics) {
        Biome.RainType rainType;
        World world = entity.func_130014_f_();
        if (world.func_72896_J() && (rainType = WorldUtils.getCurrentPrecipitationAt((IWorldReader)world, blockPos.func_177984_a())) == Biome.RainType.RAIN) {
            acoustics.add(FootstepLibrary.getRainSplashAcoustic());
        }
    }
}

