/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.client;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.MaterialUtils;
import org.orecruncher.lib.TickCounter;
import org.orecruncher.lib.blockstate.BlockStateMatcher;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.sndctrl.config.Config;
import org.orecruncher.sndctrl.events.BlockInspectionEvent;
import org.orecruncher.sndctrl.events.EntityInspectionEvent;
import org.orecruncher.sndctrl.library.AudioEffectLibrary;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Inspector {
    private static final String TEXT_BLOCKSTATE = TextFormatting.DARK_PURPLE + "<BlockState>";
    private static final String TEXT_TAGS = TextFormatting.DARK_PURPLE + "<Tags>";
    private static List<String> diagnostics = ImmutableList.of();

    private Inspector() {
    }

    private static List<String> getTags(@Nonnull BlockState state) {
        return state.func_177230_c().getTags().stream().map(t -> "#" + t.toString()).collect(Collectors.toList());
    }

    private static void gatherBlockText(ItemStack stack, List<String> text, BlockState state, BlockPos pos) {
        BlockStateMatcher info;
        if (!stack.func_190926_b()) {
            text.add(TextFormatting.RED + stack.func_200301_q().getString());
            String itemName = stack.func_77973_b().func_200296_o().getString();
            if (!StringUtils.isEmpty((CharSequence)itemName)) {
                text.add("ITEM: " + itemName);
                text.add(TextFormatting.DARK_AQUA + stack.func_77973_b().getClass().getName());
            }
        }
        if (state != null && !(info = BlockStateMatcher.create(state)).isEmpty()) {
            text.add("BLOCK: " + info.toString());
            text.add(TextFormatting.DARK_AQUA + info.getBlock().getClass().getName());
            text.add("Material: " + MaterialUtils.getMaterialName(state.func_185904_a()));
            SoundType st = state.func_215695_r();
            text.add("Step Sound: " + st.func_185844_d().getRegistryName().toString());
            text.add("Reflectivity: " + AudioEffectLibrary.getReflectivity(state));
            text.add("Occlusion: " + AudioEffectLibrary.getOcclusion(state));
            text.add(TEXT_BLOCKSTATE);
            CompoundNBT nbt = NBTUtil.func_190009_a((BlockState)state);
            text.add(nbt.toString());
            List<String> tagNames = Inspector.getTags(state);
            if (tagNames.size() > 0) {
                text.add(TEXT_TAGS);
                for (String ore : tagNames) {
                    text.add(TextFormatting.GOLD + ore);
                }
            }
        }
    }

    private static boolean isHolding() {
        PlayerEntity player = GameUtils.getPlayer();
        if (player == null) {
            return false;
        }
        ItemStack held = player.func_184586_b(Hand.MAIN_HAND);
        return !held.func_190926_b() && held.func_77973_b() == Items.field_151146_bM;
    }

    @SubscribeEvent
    public static void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (TickCounter.getTickCount() % 5L == 0L) {
            diagnostics = ImmutableList.of();
            if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue() && Inspector.isHolding()) {
                ClientWorld world = GameUtils.getWorld();
                if (GameUtils.getMC().field_147125_j != null) {
                    EntityInspectionEvent evt = new EntityInspectionEvent(GameUtils.getMC().field_147125_j);
                    evt.data.add(TextFormatting.RED + "Entity " + evt.entity.toString());
                    MinecraftForge.EVENT_BUS.post((Event)evt);
                    diagnostics = evt.data;
                } else {
                    BlockState state;
                    BlockRayTraceResult trace;
                    RayTraceResult current = GameUtils.getMC().field_71476_x;
                    if (current instanceof BlockRayTraceResult && (trace = (BlockRayTraceResult)current).func_216346_c() != RayTraceResult.Type.MISS && !(state = world.func_180495_p(trace.func_216350_a())).isAir((IBlockReader)world, trace.func_216350_a())) {
                        BlockInspectionEvent evt = new BlockInspectionEvent(trace, (World)world, state, trace.func_216350_a());
                        MinecraftForge.EVENT_BUS.post((Event)evt);
                        diagnostics = evt.data;
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockInspectionEvent(@Nonnull BlockInspectionEvent event) {
        ItemStack stack = event.state.func_177230_c().getPickBlock(event.state, (RayTraceResult)event.rayTrace, (IBlockReader)event.world, event.pos, GameUtils.getPlayer());
        Inspector.gatherBlockText(stack, event.data, event.state, event.pos);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onGatherText(@Nonnull DiagnosticEvent event) {
        event.getLeft().addAll(diagnostics);
    }
}

