/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.library;

import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.lib.MaterialUtils;
import org.orecruncher.lib.blockstate.BlockStateMatcherMap;
import org.orecruncher.lib.fml.ForgeUtils;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.resource.IResourceAccessor;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.lib.service.IModuleService;
import org.orecruncher.lib.service.ModuleServiceManager;
import org.orecruncher.lib.tags.TagUtils;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.misc.IMixinAudioEffectData;

@OnlyIn(value=Dist.CLIENT)
public final class AudioEffectLibrary {
    private static final String MATERIAL_PREFIX = "+";
    private static final String TAG_PREFIX = "#";
    private static final float DEFAULT_OPAQUE_OCCLUSION = 0.5f;
    private static final float DEFAULT_TRANSLUCENT_OCCLUSION = 0.15f;
    private static final float DEFAULT_REFLECTION = 0.4f;
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(AudioEffectLibrary.class);
    private static final Object2FloatOpenHashMap<Material> materialOcclusion = new Object2FloatOpenHashMap();
    private static final BlockStateMatcherMap<Float> blockStateOcclusionMap = new BlockStateMatcherMap();
    private static final Object2FloatOpenHashMap<Material> materialReflect = new Object2FloatOpenHashMap();
    private static final BlockStateMatcherMap<Float> blockStateReflectMap = new BlockStateMatcherMap();
    private static final Object2FloatOpenHashMap<ResourceLocation> fluidCoefficient = new Object2FloatOpenHashMap();

    public static void initialize() {
        ModuleServiceManager.instance().add(new AudioEffectLibraryService());
    }

    public static float getOcclusion(@Nonnull BlockState state) {
        return AudioEffectLibrary.resolve((BlockState)state).occlusion;
    }

    public static float getReflectivity(@Nonnull BlockState state) {
        return AudioEffectLibrary.resolve((BlockState)state).reflectivity;
    }

    private static EffectData resolve(@Nonnull BlockState state) {
        IMixinAudioEffectData accessor = (IMixinAudioEffectData)state;
        EffectData data = accessor.getData();
        if (data == null) {
            float o = AudioEffectLibrary.resolveOcclusion(state);
            float r = AudioEffectLibrary.resolveReflectivity(state);
            data = new EffectData(o, r);
            accessor.setData(data);
        }
        return data;
    }

    private static float resolveReflectivity(@Nonnull BlockState state) {
        Float result = blockStateReflectMap.get(state);
        if (result == null || result.floatValue() < 0.0f) {
            result = Float.valueOf(materialReflect.getFloat((Object)state.func_185904_a()));
        }
        return result.floatValue() < 0.0f ? 0.4f : result.floatValue();
    }

    private static float resolveOcclusion(@Nonnull BlockState state) {
        Float result = blockStateOcclusionMap.get(state);
        if ((result == null || result.floatValue() < 0.0f) && (result = Float.valueOf(materialOcclusion.getFloat((Object)state.func_185904_a()))).floatValue() < 0.0f) {
            result = Float.valueOf(state.func_185904_a().func_76218_k() ? 0.5f : 0.15f);
        }
        return result.floatValue();
    }

    public static float getFluidCoeffcient(@Nonnull ResourceLocation res) {
        return fluidCoefficient.getFloat((Object)res);
    }

    private static void processOcclusions(@Nonnull EffectOptions options) {
        for (Map.Entry<String, Float> kvp : options.occlusions.entrySet()) {
            String name = kvp.getKey();
            if (name.startsWith(MATERIAL_PREFIX)) {
                String materialName = name.substring(1);
                Material mat = MaterialUtils.getMaterial(materialName);
                if (mat != null) {
                    materialOcclusion.put((Object)mat, kvp.getValue().floatValue());
                    continue;
                }
                LOGGER.debug("Unrecognized material name: %s", materialName);
                continue;
            }
            if (name.startsWith(TAG_PREFIX)) {
                String tagName = name.substring(1);
                ITag<Block> tag = TagUtils.getBlockTag(tagName);
                if (tag != null) {
                    for (Block block : tag.func_230236_b_()) {
                        for (BlockState state : block.func_176194_O().func_177619_a()) {
                            blockStateOcclusionMap.put(state, kvp.getValue());
                        }
                    }
                    continue;
                }
                LOGGER.debug("Unrecognized block tag: %s", tagName);
                continue;
            }
            try {
                blockStateOcclusionMap.put(name, kvp.getValue());
            }
            catch (Throwable t) {
                LOGGER.error(t, "Unable to insert entry into block state map: %s", t.getMessage());
            }
        }
        blockStateOcclusionMap.put(Blocks.field_150350_a, Float.valueOf(0.0f));
        blockStateOcclusionMap.put(Blocks.field_201941_jj, Float.valueOf(0.0f));
        blockStateOcclusionMap.put(Blocks.field_201940_ji, Float.valueOf(0.0f));
    }

    private static void processReflectivity(@Nonnull EffectOptions options) {
        for (Map.Entry<String, Float> kvp : options.reflectivity.entrySet()) {
            String name = kvp.getKey();
            float val = MathStuff.clamp(kvp.getValue().floatValue(), 0.0f, 2.0f);
            if (name.startsWith(MATERIAL_PREFIX)) {
                String materialName = name.substring(1);
                Material mat = MaterialUtils.getMaterial(materialName);
                if (mat != null) {
                    materialReflect.put((Object)mat, val);
                    continue;
                }
                LOGGER.debug("Unrecognized material name: %s", materialName);
                continue;
            }
            if (name.startsWith(TAG_PREFIX)) {
                String tagName = name.substring(1);
                ITag<Block> tag = TagUtils.getBlockTag(tagName);
                if (tag != null) {
                    for (Block block : tag.func_230236_b_()) {
                        for (BlockState state : block.func_176194_O().func_177619_a()) {
                            blockStateReflectMap.put(state, Float.valueOf(val));
                        }
                    }
                    continue;
                }
                LOGGER.debug("Unrecognized block tag: %s", tagName);
                continue;
            }
            try {
                blockStateReflectMap.put(name, Float.valueOf(val));
            }
            catch (Throwable t) {
                LOGGER.error(t, "Unable to insert entry into block state map: %s", t.getMessage());
            }
        }
        blockStateReflectMap.put(Blocks.field_150350_a, Float.valueOf(0.0f));
        blockStateReflectMap.put(Blocks.field_201941_jj, Float.valueOf(0.0f));
        blockStateReflectMap.put(Blocks.field_201940_ji, Float.valueOf(0.0f));
    }

    private static void processLowpass(@Nonnull EffectOptions options) {
        for (Map.Entry<String, Float> kvp : options.fluid.entrySet()) {
            fluidCoefficient.put((Object)new ResourceLocation(kvp.getKey()), kvp.getValue().floatValue());
        }
    }

    private static class AudioEffectLibraryService
    implements IModuleService {
        private AudioEffectLibraryService() {
        }

        @Override
        public String name() {
            return "AudioEffectLibrary";
        }

        @Override
        public void start() {
            materialOcclusion.defaultReturnValue(-1.0f);
            for (Material mat : MaterialUtils.getMaterials()) {
                materialOcclusion.put((Object)mat, mat.func_76218_k() ? 0.5f : 0.15f);
            }
            blockStateOcclusionMap.setDefaultValue(() -> Float.valueOf(-1.0f));
            materialReflect.defaultReturnValue(-1.0f);
            blockStateReflectMap.setDefaultValue(() -> Float.valueOf(-1.0f));
            fluidCoefficient.defaultReturnValue(0.0f);
            fluidCoefficient.put((Object)new ResourceLocation("sndctrl:default"), 0.0f);
            Collection<IResourceAccessor> configs = ResourceUtils.findConfigs("dsurround", DynamicSurroundings.DATA_PATH, "effects.json");
            IResourceAccessor.process(configs, accessor -> {
                EffectOptions cfg = accessor.as(EffectOptions.class);
                AudioEffectLibrary.processOcclusions(cfg);
                AudioEffectLibrary.processReflectivity(cfg);
                AudioEffectLibrary.processLowpass(cfg);
            });
        }

        @Override
        public void stop() {
            materialOcclusion.clear();
            materialReflect.clear();
            blockStateOcclusionMap.clear();
            blockStateReflectMap.clear();
            fluidCoefficient.clear();
            ForgeUtils.getBlockStates().forEach(state -> {
                IMixinAudioEffectData accessor = (IMixinAudioEffectData)state;
                accessor.setData(null);
            });
        }

        @Override
        public void reload() {
            this.stop();
            this.start();
        }
    }

    public static class EffectData {
        public final float occlusion;
        public final float reflectivity;

        public EffectData(float o, float r) {
            this.occlusion = o;
            this.reflectivity = r;
        }
    }

    public static class EffectOptions {
        @SerializedName(value="occlusions")
        public Map<String, Float> occlusions = ImmutableMap.of();
        @SerializedName(value="reflectivity")
        public Map<String, Float> reflectivity = ImmutableMap.of();
        @SerializedName(value="fluid")
        public Map<String, Float> fluid = ImmutableMap.of();
    }
}

