/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.tainted.save.TimedDataSave;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public final class TemplateSave
extends TimedDataSave<TemplateInfo> {
    public TemplateSave(String name) {
        super(name);
    }

    public Template getTemplate(UUID id) {
        TemplateInfo info = this.get(id, uuid -> new TemplateInfo());
        return this.markDirtyAndUpdate(info).getTemplate();
    }

    void setTemplate(UUID id, Template template) {
        this.markDirtyAndUpdate(this.get(id, uuid -> new TemplateInfo(template))).setTemplate(template);
    }

    void removeTemplate(UUID id) {
        this.remove(id);
        this.func_76185_a();
    }

    @Override
    protected TemplateInfo createValue() {
        return new TemplateInfo();
    }

    @Override
    protected TemplateInfo readValue(CompoundNBT nbt) {
        return new TemplateInfo(nbt);
    }

    private TemplateInfo markDirtyAndUpdate(TemplateInfo info) {
        this.func_76185_a();
        return info.updateTime();
    }

    static final class TemplateInfo
    extends TimedDataSave.TimedValue {
        private Template template;

        private TemplateInfo(CompoundNBT nbt) {
            super(nbt);
            this.template = Template.deserialize(nbt.func_74775_l("data"), null, true);
        }

        private TemplateInfo(Template template) {
            this.template = template;
        }

        private TemplateInfo(long lastUpdateTime, Template template) {
            super(lastUpdateTime);
            this.template = template;
        }

        private TemplateInfo() {
            this(new Template());
        }

        private Template getTemplate() {
            return this.template;
        }

        public TemplateInfo setTemplate(Template template) {
            this.template = template;
            return this;
        }

        @Override
        public TemplateInfo updateTime() {
            return (TemplateInfo)super.updateTime();
        }

        @Override
        public CompoundNBT write() {
            CompoundNBT nbt = super.write();
            nbt.func_218657_a("data", (INBT)this.template.serialize(true));
            return nbt;
        }
    }
}

