/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.util.tools;

import com.direwolf20.buildinggadgets.common.capability.IPrivateEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class SimulateEnergyStorage
implements IPrivateEnergy {
    private final IEnergyStorage other;
    private int energyChanged;

    public SimulateEnergyStorage(IEnergyStorage other) {
        this.other = other;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = this.other.receiveEnergy(maxReceive + this.energyChanged, true);
        int dif = Math.max(received - this.energyChanged, 0);
        if (!simulate) {
            this.energyChanged += dif;
        }
        return dif;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int extractPower(int maxExtract, boolean simulate) {
        int extracted = this.other.extractEnergy(maxExtract - this.energyChanged, true);
        int dif = Math.max(extracted + this.energyChanged, 0);
        if (!simulate) {
            this.energyChanged -= dif;
        }
        return dif;
    }

    public int getEnergyStored() {
        return Math.max(this.other.getEnergyStored() + this.energyChanged, 0);
    }

    public int getMaxEnergyStored() {
        return this.other.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.other.canExtract();
    }

    public boolean canReceive() {
        return this.other.canReceive();
    }
}

