/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.block.addon;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class VariantVerticalSlabBlock
extends Block
implements IWaterLoggable {
    public static EnumProperty<VariantVerticalSlabType> TYPE = EnumProperty.func_177709_a((String)"type", VariantVerticalSlabType.class);
    public static BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static VoxelShape EAST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static VoxelShape WEST_SHAPE = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);

    public VariantVerticalSlabBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)VariantVerticalSlabType.NORTH))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b(TYPE) != VariantVerticalSlabType.DOUBLE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos position, ISelectionContext context) {
        VariantVerticalSlabType type = (VariantVerticalSlabType)((Object)state.func_177229_b(TYPE));
        if (type == VariantVerticalSlabType.DOUBLE) {
            return VoxelShapes.func_197868_b();
        }
        if (type == VariantVerticalSlabType.WEST) {
            return WEST_SHAPE;
        }
        if (type == VariantVerticalSlabType.EAST) {
            return EAST_SHAPE;
        }
        if (type == VariantVerticalSlabType.SOUTH) {
            return SOUTH_SHAPE;
        }
        return NORTH_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos position = context.func_195995_a();
        BlockState doubleState = context.func_195991_k().func_180495_p(position);
        if (doubleState.func_177230_c() == this) {
            return (BlockState)((BlockState)doubleState.func_206870_a(TYPE, (Comparable)((Object)VariantVerticalSlabType.DOUBLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidState = context.func_195991_k().func_204610_c(position);
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        Direction direction = this.getDirectionForPlacement(context);
        VariantVerticalSlabType type = VariantVerticalSlabType.getType(direction);
        return (BlockState)state.func_206870_a(TYPE, (Comparable)((Object)type));
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        VariantVerticalSlabType type = (VariantVerticalSlabType)((Object)state.func_177229_b(TYPE));
        return type != VariantVerticalSlabType.DOUBLE && stack.func_77973_b() == this.func_199767_j() && (context.func_196012_c() && context.func_196000_l() == type.direction && this.getDirectionForPlacement(context) == type.direction || !context.func_196012_c() && context.func_196000_l().func_176740_k() != type.direction.func_176740_k());
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld world, BlockPos position, BlockState state, FluidState fluidState) {
        return state.func_177229_b(TYPE) != VariantVerticalSlabType.DOUBLE && super.func_204509_a(world, position, state, fluidState);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos position, BlockState state, Fluid fluid) {
        return state.func_177229_b(TYPE) != VariantVerticalSlabType.DOUBLE && super.func_204510_a(world, position, state, fluid);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos position, BlockPos facingPosition) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(position, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, position, facingPosition);
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos position, PathType pathType) {
        return pathType == PathType.WATER && world.func_204610_c(position).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    private Direction getDirectionForPlacement(BlockItemUseContext context) {
        Direction face = context.func_196000_l();
        if (face.func_176740_k() != Direction.Axis.Y) {
            return face;
        }
        BlockPos position = context.func_195995_a();
        Vector3d result = context.func_221532_j().func_178788_d(new Vector3d((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p())).func_178786_a(0.5, 0.0, 0.5);
        double angle = Math.atan2(result.field_72450_a, result.field_72449_c) * -180.0 / Math.PI;
        return Direction.func_176733_a((double)angle).func_176734_d();
    }

    public static enum VariantVerticalSlabType implements IStringSerializable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private String name;
        public Direction direction;

        private VariantVerticalSlabType(Direction direction) {
            this.name = direction == null ? "double" : direction.func_176610_l();
            this.direction = direction;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static VariantVerticalSlabType getType(Direction direction) {
            for (VariantVerticalSlabType type : VariantVerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }
    }
}

