/*
 * Decompiled with CFR 0.152.
 */
package net.blazekrew.variant16x.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.blazekrew.variant16x.registry.BlockRegistry;
import net.blazekrew.variant16x.registry.ConfigRegistry;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.placement.ConfiguredPlacement;

public class FeatureRegistry {
    public static ConfiguredFeature<?, ?> INFESTED_ANDESITE_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_DIORITE_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_GRANITE_CONFIG;
    public static ConfiguredFeature<?, ?> INFESTED_CLUMPS_CONFIG;
    public static ConfiguredFeature<?, ?> PAEONIA_CONFIG;
    public static ConfiguredFeature<?, ?> ROSE_CONFIG;
    public static ConfiguredFeature<?, ?> SYRINGA_CONFIG;
    public static ConfiguredFeature<?, ?> SMALL_SUNFLOWER_CONFIG;
    public static ConfiguredFeature<?, ?> RARE_PAEONIA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> PAEONIA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> RARE_ROSE_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> ROSE_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> RARE_SYRINGA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> SYRINGA_PATCHES_CONFIG;
    public static ConfiguredFeature<?, ?> SMALL_SUNFLOWER_PATCHES_CONFIG;

    public static void registerFeatures() {
        if (((Boolean)ConfigRegistry.ENABLE_MISCELLANEOUS.get()).booleanValue()) {
            if (((Boolean)ConfigRegistry.ENABLE_INFESTED_STONES.get()).booleanValue()) {
                INFESTED_ANDESITE_CONFIG = FeatureRegistry.registerInfestedVariant(BlockRegistry.INFESTED_ANDESITE);
                INFESTED_DIORITE_CONFIG = FeatureRegistry.registerInfestedVariant(BlockRegistry.INFESTED_DIORITE);
                INFESTED_GRANITE_CONFIG = FeatureRegistry.registerInfestedVariant(BlockRegistry.INFESTED_GRANITE);
                INFESTED_CLUMPS_CONFIG = FeatureRegistry.registerClump();
                FeatureRegistry.register(INFESTED_CLUMPS_CONFIG, "variant16x", "infested_clumps");
            }
            if (((Boolean)ConfigRegistry.ENABLE_SMALL_FLOWERS.get()).booleanValue()) {
                PAEONIA_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.PAEONIA);
                ROSE_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.ROSE);
                SYRINGA_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.SYRINGA);
                SMALL_SUNFLOWER_CONFIG = FeatureRegistry.registerPlant(BlockRegistry.SMALL_SUNFLOWER);
                RARE_PAEONIA_PATCHES_CONFIG = FeatureRegistry.registerPatch(PAEONIA_CONFIG, 1);
                PAEONIA_PATCHES_CONFIG = FeatureRegistry.registerPatch(PAEONIA_CONFIG, 10);
                RARE_ROSE_PATCHES_CONFIG = FeatureRegistry.registerPatch(ROSE_CONFIG, 1);
                ROSE_PATCHES_CONFIG = FeatureRegistry.registerPatch(ROSE_CONFIG, 10);
                RARE_SYRINGA_PATCHES_CONFIG = FeatureRegistry.registerPatch(SYRINGA_CONFIG, 1);
                SYRINGA_PATCHES_CONFIG = FeatureRegistry.registerPatch(SYRINGA_CONFIG, 10);
                SMALL_SUNFLOWER_PATCHES_CONFIG = FeatureRegistry.registerPatch(SMALL_SUNFLOWER_CONFIG, 11);
                FeatureRegistry.register(RARE_PAEONIA_PATCHES_CONFIG, "variant16x", "rare_paeonia_patches");
                FeatureRegistry.register(PAEONIA_PATCHES_CONFIG, "variant16x", "paeonia_patches");
                FeatureRegistry.register(RARE_ROSE_PATCHES_CONFIG, "variant16x", "rare_rose_patches");
                FeatureRegistry.register(ROSE_PATCHES_CONFIG, "variant16x", "rose_patches");
                FeatureRegistry.register(RARE_SYRINGA_PATCHES_CONFIG, "variant16x", "rare_syringa_patches");
                FeatureRegistry.register(SYRINGA_PATCHES_CONFIG, "variant16x", "syringa_patches");
                FeatureRegistry.register(SMALL_SUNFLOWER_PATCHES_CONFIG, "variant16x", "small_sunflower_patches");
            }
        }
    }

    public static <FC extends IFeatureConfig> ConfiguredFeature<?, ?> register(ConfiguredFeature<FC, ?> feature, String modId, String featureId) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(modId, featureId), feature);
    }

    public static ConfiguredFeature<?, ?> registerInfestedVariant(Block block) {
        return Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, block.func_176223_P(), 7));
    }

    public static ConfiguredFeature<?, ?> registerPlant(Block block) {
        return Feature.field_227248_z_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(block.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_());
    }

    public static ConfiguredFeature<?, ?> registerClump() {
        return (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)INFESTED_ANDESITE_CONFIG.func_227227_a_(0.33f), (Object)INFESTED_DIORITE_CONFIG.func_227227_a_(0.33f)), INFESTED_GRANITE_CONFIG)).func_242733_d(64)).func_242728_a()).func_242731_b(5);
    }

    public static ConfiguredFeature<?, ?> registerPatch(ConfiguredFeature<?, ?> feature, int count) {
        return ((ConfiguredFeature)Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of(() -> feature))).func_242730_a(FeatureSpread.func_242253_a((int)-3, (int)4))).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(count));
    }
}

