/*
 * Decompiled with CFR 0.152.
 */
package com.commodorethrawn.strawgolem.events;

import com.commodorethrawn.strawgolem.Strawgolem;
import com.commodorethrawn.strawgolem.config.ConfigHelper;
import com.commodorethrawn.strawgolem.entity.EntityStrawGolem;
import com.commodorethrawn.strawgolem.storage.StrawgolemSaveData;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

@Mod.EventBusSubscriber(modid="strawgolem", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CropGrowthHandler {
    private static boolean isLoaded = false;
    protected static final PriorityQueue<CropQueueEntry> queue = new PriorityQueue();
    private static final int HARVEST_DELAY = 100;
    static StrawgolemSaveData data;
    private static int ticks;

    private CropGrowthHandler() {
    }

    @SubscribeEvent
    public static void serverStart(FMLServerStartingEvent event) {
        Strawgolem.logger.info("Strawgolem: Server Starting");
        ServerWorld world = event.getServer().func_71218_a(World.field_234918_g_);
        if (world == null) {
            return;
        }
        data = StrawgolemSaveData.get(world);
        isLoaded = true;
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && EffectiveSide.get().isServer() && isLoaded) {
            while (!queue.isEmpty() && ticks == queue.peek().tick) {
                ((CropQueueEntry)queue.remove()).execute();
                data.func_76185_a();
            }
            ++ticks;
        }
    }

    @SubscribeEvent
    public static void onCropGrowth(BlockEvent.CropGrowEvent.Post event) {
        CropGrowthHandler.onCropGrowth((World)event.getWorld(), event.getPos());
    }

    @SubscribeEvent
    public static void onCropGrowth(BonemealEvent event) {
        CropGrowthHandler.onCropGrowth(event.getWorld(), event.getPos());
    }

    private static void onCropGrowth(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockPos cropPos = pos;
            if (world.func_180495_p(cropPos).func_177230_c() instanceof AttachedStemBlock) {
                Direction facing = (Direction)world.func_180495_p(cropPos).func_177229_b((Property)AttachedStemBlock.field_196280_a);
                cropPos = cropPos.func_177971_a(facing.func_176730_m());
            }
            if (CropGrowthHandler.isFullyGrown((IWorld)world, cropPos)) {
                EntityStrawGolem golem = CropGrowthHandler.getCropGolem((IWorld)world, cropPos);
                if (golem != null) {
                    golem.setHarvesting(cropPos);
                } else {
                    CropGrowthHandler.scheduleCrop(world, cropPos, 12);
                }
            }
        }
    }

    private static EntityStrawGolem getCropGolem(IWorld world, BlockPos pos) {
        AxisAlignedBB golemAABB = new AxisAlignedBB(pos).func_72314_b((double)ConfigHelper.getSearchRangeHorizontal(), (double)ConfigHelper.getSearchRangeVertical(), (double)ConfigHelper.getSearchRangeHorizontal());
        List golemList = world.func_217357_a(EntityStrawGolem.class, golemAABB);
        for (EntityStrawGolem golem : golemList) {
            if (!golem.getHarvestPos().equals((Object)BlockPos.field_177992_a) || !golem.canSeeBlock((IWorldReader)world, pos) || !golem.isHandEmpty()) continue;
            return golem;
        }
        return null;
    }

    private static boolean isFullyGrown(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (ConfigHelper.blockHarvestAllowed(state.func_177230_c())) {
            if (state.func_177230_c() instanceof CropsBlock) {
                CropsBlock crop = (CropsBlock)state.func_177230_c();
                return crop.func_185525_y(state);
            }
            if (state.func_177230_c() instanceof StemGrownBlock) {
                return true;
            }
            if (state.func_177230_c() instanceof NetherWartBlock) {
                return (Integer)state.func_177229_b((Property)NetherWartBlock.field_176486_a) == 3;
            }
            if (state.func_177230_c() instanceof BushBlock && state.func_177230_c() instanceof IGrowable && state.func_235901_b_((Property)BlockStateProperties.field_208168_U)) {
                return (Integer)state.func_177229_b((Property)BlockStateProperties.field_208168_U) == 3;
            }
        }
        return false;
    }

    public static void scheduleCrop(World world, BlockPos pos, int runsLeft) {
        if (runsLeft <= 0) {
            return;
        }
        int executeTick = ticks + 100;
        queue.add(new CropQueueEntry(pos, world, executeTick, runsLeft));
        if (data != null) {
            data.func_76185_a();
        }
    }

    public static Iterator<CropQueueEntry> getCrops() {
        return queue.iterator();
    }

    static {
        ticks = 0;
    }

    public static class CropQueueEntry
    implements Comparable<CropQueueEntry> {
        private final BlockPos pos;
        private final World world;
        private final int tick;
        private int count;

        public BlockPos getPos() {
            return this.pos;
        }

        public World getWorld() {
            return this.world;
        }

        public CropQueueEntry(BlockPos pos, World world, int tick, int count) {
            this.pos = pos;
            this.world = world;
            this.tick = tick;
            this.count = count;
        }

        public void execute() {
            if (this.world.func_175667_e(this.pos)) {
                if (CropGrowthHandler.isFullyGrown((IWorld)this.world, this.pos)) {
                    EntityStrawGolem golem = CropGrowthHandler.getCropGolem((IWorld)this.world, this.pos);
                    if (golem != null) {
                        golem.setHarvesting(this.pos);
                        return;
                    }
                    CropGrowthHandler.scheduleCrop(this.world, this.pos, --this.count);
                }
            } else {
                CropGrowthHandler.scheduleCrop(this.world, this.pos, this.count);
            }
        }

        @Override
        public int compareTo(CropQueueEntry entry) {
            if (entry.tick == this.tick) {
                if (entry.count == this.count) {
                    return 0;
                }
                return entry.count > this.count ? 1 : -1;
            }
            return entry.tick > this.tick ? -1 : 1;
        }
    }
}

