/*
 * Decompiled with CFR 0.152.
 */
package com.tome.bettershields;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class Config {
    private static CommentedFileConfig cfg;
    private static final ForgeConfigSpec.Builder builder;
    private static final String CATEGORY_GENERAL = "general";
    public static ForgeConfigSpec.BooleanValue customShieldMaxReduction;
    public static ForgeConfigSpec.ConfigValue<Integer> defaultDamageReduction;
    public static ForgeConfigSpec.ConfigValue<Integer> ironDamageReduction;
    public static ForgeConfigSpec.ConfigValue<Integer> goldDamageReduction;
    public static ForgeConfigSpec.ConfigValue<Integer> diamondDamageReduction;
    public static ForgeConfigSpec.ConfigValue<Integer> netheriteDamageReduction;
    public static ForgeConfigSpec.ConfigValue<Integer> ironDurability;
    public static ForgeConfigSpec.ConfigValue<Integer> goldDurability;
    public static ForgeConfigSpec.ConfigValue<Integer> diamondDurability;
    public static ForgeConfigSpec.ConfigValue<Integer> netheriteDurability;
    public static ForgeConfigSpec.BooleanValue thornsOnShields;

    public Config() {
        cfg = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(FMLPaths.CONFIGDIR.get().toString(), "bettershields-common.toml")).sync().autosave().build();
        cfg.load();
        this.initConfig();
        ForgeConfigSpec spec = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, spec, cfg.getFile().getName());
        spec.setConfig((CommentedConfig)cfg);
    }

    private void initConfig() {
        builder.comment("The general configuration for this mod").push(CATEGORY_GENERAL).pop();
        customShieldMaxReduction = Config.getBoolean("customShieldMaxReduction", CATEGORY_GENERAL, true, "If set to true Shields added by other mods block 100% of the incomming damage, if set to false the will block the amount set in defaultDamageReduction.");
        defaultDamageReduction = Config.getInt("defaultDamageReduction", CATEGORY_GENERAL, 75, "The portion of the incomming damage Vanilla Shields block in percent.");
        ironDamageReduction = Config.getInt("ironDamageReduction", CATEGORY_GENERAL, 90, "The portion of the incomming damage Iron Shields block in percent.");
        goldDamageReduction = Config.getInt("goldDamageReduction", CATEGORY_GENERAL, 85, "The portion of the incomming damage Gold Shields block in percent.");
        diamondDamageReduction = Config.getInt("diamondDamageReduction", CATEGORY_GENERAL, 98, "The portion of the incomming damage Diamond Shields block in percent.");
        netheriteDamageReduction = Config.getInt("netheriteDamageReduction", CATEGORY_GENERAL, 100, "The portion of the incomming damage Netherite Shields block in percent.");
        ironDurability = Config.getInt("ironDurability", CATEGORY_GENERAL, 920, "The durability of the Iron Shield.");
        goldDurability = Config.getInt("goldDurability", CATEGORY_GENERAL, 130, "The durability of the Gold Shield.");
        diamondDurability = Config.getInt("diamondDurability", CATEGORY_GENERAL, 4600, "The durability of the Diamond Shield.");
        netheriteDurability = Config.getInt("netheriteDurability", CATEGORY_GENERAL, 6300, "The durability of the Netherite Shield.");
        thornsOnShields = Config.getBoolean("thornsOnShields", CATEGORY_GENERAL, true, "Allows the Thorns enchantment to by applied to Shields");
    }

    private static ForgeConfigSpec.BooleanValue getBoolean(String name, String category, boolean defaultValue, String comment) {
        String path = category + "." + name;
        return builder.comment(new String[]{comment, "Default: " + defaultValue}).define(path, defaultValue);
    }

    private static ForgeConfigSpec.ConfigValue<Integer> getInt(String name, String category, int defaultValue, String comment) {
        String path = category + "." + name;
        return builder.comment(new String[]{comment, "Default: " + defaultValue}).define(path, (Object)defaultValue);
    }

    static {
        builder = new ForgeConfigSpec.Builder();
    }
}

