/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.easymagic.inventory.container;

import com.fuzs.easymagic.EasyMagic;
import com.fuzs.easymagic.element.EasyEnchantingElement;
import com.fuzs.easymagic.mixin.accessor.IEnchantmentContainerAccessor;
import com.fuzs.easymagic.network.message.SEnchantingInfoMessage;
import com.fuzs.puzzleslib_em.PuzzlesLib;
import com.fuzs.puzzleslib_em.network.message.Message;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantmentInventoryContainer
extends EnchantmentContainer {
    public boolean closed;
    private Consumer<SEnchantingInfoMessage> sendEnchantingInfo;

    public EnchantmentInventoryContainer(int id, PlayerInventory playerInventory) {
        super(id, playerInventory);
        this.updateInventory(playerInventory, (IInventory)new Inventory(2));
    }

    public EnchantmentInventoryContainer(int id, PlayerInventory playerInventory, IInventory inventory, IWorldPosCallable worldPosCallable) {
        super(id, playerInventory, worldPosCallable);
        this.updateInventory(playerInventory, inventory);
        if (playerInventory.field_70458_d instanceof ServerPlayerEntity) {
            this.sendEnchantingInfo = message -> PuzzlesLib.getNetworkHandler().sendTo((Message)message, (ServerPlayerEntity)playerInventory.field_70458_d);
        }
        if (((EasyEnchantingElement)EasyMagic.EASY_ENCHANTING).reRollEnchantments) {
            this.get().getXpSeed().func_221494_a(playerInventory.field_70458_d.func_70681_au().nextInt());
        }
    }

    public void onCraftMatrixChanged() {
        this.func_75130_a(this.get().getTableInventory());
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (inventoryIn == this.get().getTableInventory()) {
            ItemStack enchantedItem = inventoryIn.func_70301_a(0);
            if (!enchantedItem.func_190926_b() && enchantedItem.func_77956_u()) {
                this.get().getWorldPosCallable().func_221486_a((world, pos) -> {
                    EasyEnchantingElement element = (EasyEnchantingElement)EasyMagic.EASY_ENCHANTING;
                    int power = element.maxPower == 0 ? 15 : this.getEnchantingPower((World)world, (BlockPos)pos) * 15 / element.maxPower;
                    this.get().getRand().setSeed(this.get().getXpSeed().func_221495_b());
                    this.updateLevels(enchantedItem, (World)world, (BlockPos)pos, power);
                    this.createClues(enchantedItem);
                    this.func_75142_b();
                    if (element.allEnchantments) {
                        List<EnchantmentData> firstSlotData = this.createEnchantmentData(enchantedItem, 0);
                        List<EnchantmentData> secondSlotData = this.createEnchantmentData(enchantedItem, 1);
                        List<EnchantmentData> thirdSlotData = this.createEnchantmentData(enchantedItem, 2);
                        this.sendEnchantingInfo.accept(new SEnchantingInfoMessage(this.field_75152_c, firstSlotData, secondSlotData, thirdSlotData));
                    }
                });
            } else {
                this.resetLevelsAndClues();
            }
        }
    }

    private void resetLevelsAndClues() {
        for (int i = 0; i < 3; ++i) {
            this.field_75167_g[i] = 0;
            this.field_185001_h[i] = -1;
            this.field_185002_i[i] = -1;
        }
    }

    private void updateLevels(ItemStack itemstack, World world, BlockPos pos, int power) {
        for (int i1 = 0; i1 < 3; ++i1) {
            this.field_75167_g[i1] = EnchantmentHelper.func_77514_a((Random)this.get().getRand(), (int)i1, (int)power, (ItemStack)itemstack);
            if (this.field_75167_g[i1] < i1 + 1) {
                this.field_75167_g[i1] = 0;
            }
            this.field_75167_g[i1] = ForgeEventFactory.onEnchantmentLevelSet((World)world, (BlockPos)pos, (int)i1, (int)power, (ItemStack)itemstack, (int)this.field_75167_g[i1]);
        }
    }

    private void createClues(ItemStack itemstack) {
        for (int j1 = 0; j1 < 3; ++j1) {
            List<EnchantmentData> list;
            if (this.field_75167_g[j1] <= 0 || (list = this.createEnchantmentData(itemstack, j1)) == null || list.isEmpty()) continue;
            EnchantmentData enchantmentdata = list.get(this.get().getRand().nextInt(list.size()));
            this.field_185001_h[j1] = ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)enchantmentdata.field_76302_b);
            this.field_185002_i[j1] = enchantmentdata.field_76303_c;
        }
    }

    private List<EnchantmentData> createEnchantmentData(ItemStack enchantedItem, int enchantSlot) {
        return this.get().callGetEnchantmentList(enchantedItem, enchantSlot, this.field_75167_g[enchantSlot]);
    }

    private int getEnchantingPower(World world, BlockPos pos) {
        int power = 0;
        for (int k = -1; k <= 1; ++k) {
            for (int l = -1; l <= 1; ++l) {
                if (k == 0 && l == 0 || !EnchantmentInventoryContainer.isBlockEmpty(world, pos.func_177982_a(l, 0, k)) || !EnchantmentInventoryContainer.isBlockEmpty(world, pos.func_177982_a(l, 1, k))) continue;
                power = (int)((float)power + this.getPower(world, pos.func_177982_a(l * 2, 0, k * 2)));
                power = (int)((float)power + this.getPower(world, pos.func_177982_a(l * 2, 1, k * 2)));
                if (l == 0 || k == 0) continue;
                power = (int)((float)power + this.getPower(world, pos.func_177982_a(l * 2, 0, k)));
                power = (int)((float)power + this.getPower(world, pos.func_177982_a(l * 2, 1, k)));
                power = (int)((float)power + this.getPower(world, pos.func_177982_a(l, 0, k * 2)));
                power = (int)((float)power + this.getPower(world, pos.func_177982_a(l, 1, k * 2)));
            }
        }
        return power;
    }

    public static boolean isBlockEmpty(World world, BlockPos pos) {
        if (((EasyEnchantingElement)EasyMagic.EASY_ENCHANTING).lenientBookshelves) {
            return world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b();
        }
        return world.func_175623_d(pos);
    }

    private float getPower(World world, BlockPos pos) {
        return world.func_180495_p(pos).getEnchantPowerBonus((IWorldReader)world, pos);
    }

    public ContainerType<?> func_216957_a() {
        return EasyEnchantingElement.ENCHANTMENT_CONTAINER;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        EasyEnchantingElement element = (EasyEnchantingElement)EasyMagic.EASY_ENCHANTING;
        if (!element.itemsStay) {
            return super.func_75145_c(playerIn);
        }
        return this.get().getTableInventory().func_70300_a(playerIn);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        this.closed = true;
        EasyEnchantingElement element = (EasyEnchantingElement)EasyMagic.EASY_ENCHANTING;
        if (!element.itemsStay) {
            super.func_75134_a(playerIn);
            return;
        }
        PlayerInventory playerinventory = playerIn.field_71071_by;
        if (!playerinventory.func_70445_o().func_190926_b()) {
            playerIn.func_71019_a(playerinventory.func_70445_o(), false);
            playerinventory.func_70437_b(ItemStack.field_190927_a);
        }
    }

    private void updateInventory(PlayerInventory playerInventory, IInventory inventory) {
        if (((EasyEnchantingElement)EasyMagic.EASY_ENCHANTING).itemsStay) {
            this.get().setTableInventory(inventory);
        }
        this.field_75151_b.clear();
        this.func_75146_a(new EnchantableSlot(this.get().getTableInventory(), 0, 15, 47));
        this.func_75146_a(new LapisSlot(this.get().getTableInventory(), 1, 35, 47));
        this.addPlayerSlots(playerInventory);
    }

    private void addPlayerSlots(PlayerInventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
    }

    private IEnchantmentContainerAccessor get() {
        return (IEnchantmentContainerAccessor)((Object)this);
    }

    private static class LapisSlot
    extends Slot {
        public LapisSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            return Tags.Items.GEMS_LAPIS.func_230235_a_((Object)stack.func_77973_b());
        }
    }

    private class EnchantableSlot
    extends Slot {
        public EnchantableSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (((EasyEnchantingElement)EasyMagic.EASY_ENCHANTING).itemsStay) {
                return stack.func_77956_u() || stack.func_77973_b() == Items.field_151122_aG;
            }
            return true;
        }

        public int func_75219_a() {
            return 1;
        }

        @Nonnull
        public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
            if (((EasyEnchantingElement)EasyMagic.EASY_ENCHANTING).reRollEnchantments) {
                ((IEnchantmentContainerAccessor)((Object)EnchantmentInventoryContainer.this)).getXpSeed().func_221494_a(thePlayer.func_70681_au().nextInt());
            }
            return super.func_190901_a(thePlayer, stack);
        }
    }
}

