/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.easymagic.network.message;

import com.fuzs.easymagic.client.gui.screen.EnchantmentInventoryScreen;
import com.fuzs.puzzleslib_em.network.message.Message;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SEnchantingInfoMessage
extends Message {
    private int windowId;
    private List<EnchantmentData> firstSlotData;
    private List<EnchantmentData> secondSlotData;
    private List<EnchantmentData> thirdSlotData;

    public SEnchantingInfoMessage() {
    }

    public SEnchantingInfoMessage(int windowId, List<EnchantmentData> firstSlotData, List<EnchantmentData> secondSlotData, List<EnchantmentData> thirdSlotData) {
        this.windowId = windowId;
        this.firstSlotData = firstSlotData;
        this.secondSlotData = secondSlotData;
        this.thirdSlotData = thirdSlotData;
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeByte(this.windowId);
        this.writeEnchantmentData(buf, this.firstSlotData);
        this.writeEnchantmentData(buf, this.secondSlotData);
        this.writeEnchantmentData(buf, this.thirdSlotData);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.windowId = buf.readByte();
        this.firstSlotData = this.readEnchantmentData(buf);
        this.secondSlotData = this.readEnchantmentData(buf);
        this.thirdSlotData = this.readEnchantmentData(buf);
    }

    private void writeEnchantmentData(PacketBuffer buf, List<EnchantmentData> dataList) {
        buf.writeByte(dataList.size());
        for (EnchantmentData data : dataList) {
            buf.writeInt(((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)data.field_76302_b));
            buf.writeShort(data.field_76303_c);
        }
    }

    private List<EnchantmentData> readEnchantmentData(PacketBuffer buf) {
        int listSize = buf.readByte();
        ArrayList<EnchantmentData> slotData = new ArrayList<EnchantmentData>(listSize);
        for (int i = 0; i < listSize; ++i) {
            Enchantment enchantment = (Enchantment)((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(buf.readInt());
            slotData.add(new EnchantmentData(enchantment, (int)buf.readShort()));
        }
        return slotData;
    }

    @Override
    protected Message.MessageProcessor createProcessor() {
        return new EnchantingInfoProcessor();
    }

    private class EnchantingInfoProcessor
    implements Message.MessageProcessor {
        private EnchantingInfoProcessor() {
        }

        @Override
        public void accept(PlayerEntity playerEntity) {
            if (Minecraft.func_71410_x().field_71462_r instanceof EnchantmentInventoryScreen && playerEntity.field_71070_bA.field_75152_c == SEnchantingInfoMessage.this.windowId) {
                EnchantmentInventoryScreen screen = (EnchantmentInventoryScreen)Minecraft.func_71410_x().field_71462_r;
                screen.setSlotTooltip(0, SEnchantingInfoMessage.this.firstSlotData);
                screen.setSlotTooltip(1, SEnchantingInfoMessage.this.secondSlotData);
                screen.setSlotTooltip(2, SEnchantingInfoMessage.this.thirdSlotData);
            }
        }
    }
}

