/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_em;

import com.fuzs.puzzleslib_em.capability.CapabilityController;
import com.fuzs.puzzleslib_em.config.ConfigManager;
import com.fuzs.puzzleslib_em.element.AbstractElement;
import com.fuzs.puzzleslib_em.element.registry.ElementRegistry;
import com.fuzs.puzzleslib_em.network.NetworkHandler;
import com.fuzs.puzzleslib_em.proxy.IProxy;
import com.fuzs.puzzleslib_em.registry.RegistryManager;
import com.fuzs.puzzleslib_em.util.PuzzlesLibUtil;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PuzzlesLib {
    public static final String MODID = "puzzleslibem";
    public static final String NAME = "Puzzles Lib";
    public static final Logger LOGGER = LogManager.getLogger((String)"Puzzles Lib");
    private static IProxy<?> sidedProxy;
    private static RegistryManager registryManager;
    private static NetworkHandler networkHandler;
    private static CapabilityController capabilityController;

    public PuzzlesLib() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onServerSetup);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)PuzzlesLib.getRegistryManager());
    }

    protected void onCommonSetup(FMLCommonSetupEvent evt) {
        ElementRegistry.load((ParallelDispatchEvent)evt);
        ConfigManager.get().syncAll(ModConfig.Type.COMMON);
    }

    protected void onClientSetup(FMLClientSetupEvent evt) {
        ElementRegistry.load((ParallelDispatchEvent)evt);
        ConfigManager.get().syncAll(ModConfig.Type.CLIENT);
    }

    protected void onServerSetup(FMLDedicatedServerSetupEvent evt) {
        ElementRegistry.load((ParallelDispatchEvent)evt);
        ConfigManager.get().syncAll(ModConfig.Type.SERVER);
    }

    protected final void setSideSideOnly() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, isServer) -> true));
    }

    public static IProxy<?> getProxy() {
        return PuzzlesLibUtil.getOrElse(sidedProxy, IProxy::getProxy, instance -> {
            sidedProxy = instance;
        });
    }

    public static RegistryManager getRegistryManager() {
        return PuzzlesLibUtil.getOrElse(registryManager, RegistryManager::new, instance -> {
            registryManager = instance;
        });
    }

    public static NetworkHandler getNetworkHandler() {
        return PuzzlesLibUtil.getOrElse(networkHandler, NetworkHandler::new, instance -> {
            networkHandler = instance;
        });
    }

    public static CapabilityController getCapabilityController() {
        return PuzzlesLibUtil.getOrElse(capabilityController, CapabilityController::new, instance -> {
            capabilityController = instance;
        });
    }

    protected static <T extends AbstractElement> AbstractElement register(String key, Supplier<T> supplier) {
        return ElementRegistry.register(key, supplier);
    }

    protected static <T extends AbstractElement> AbstractElement register(String key, Supplier<T> supplier, Dist dist) {
        return ElementRegistry.register(key, supplier, dist);
    }
}

