/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_em.config;

import com.fuzs.puzzleslib_em.config.ConfigManager;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

class ConfigTypeData {
    private final ModConfig.Type type;
    private String path = "";
    private ForgeConfigSpec spec;
    private ForgeConfigSpec.Builder builder;

    ConfigTypeData(ModConfig.Type type) {
        this.type = type;
    }

    boolean isSpecNotBuilt() {
        return this.spec == null;
    }

    boolean canBuildSpec() {
        return this.builder != null;
    }

    boolean addSpec(ForgeConfigSpec spec) {
        if (this.isSpecNotBuilt()) {
            this.spec = spec;
            return true;
        }
        return false;
    }

    @Nullable
    ForgeConfigSpec getSpec() {
        if (this.isSpecNotBuilt()) {
            if (!this.canBuildSpec()) {
                return null;
            }
            this.spec = this.builder.build();
        }
        return this.spec;
    }

    ForgeConfigSpec.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = new ForgeConfigSpec.Builder();
        }
        return this.builder;
    }

    void setPrefix(String prefix) {
        this.path = prefix;
    }

    String getName(ModLoadingContext context) {
        String modId = context.getActiveContainer().getModId();
        return this.path + ConfigManager.getConfigName(modId, this.type);
    }
}

