/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class OmnisHelper {
    public static boolean areWeOnClient(World world) {
        return world.field_72995_K;
    }

    public static boolean areWeOnServer(World world) {
        return !OmnisHelper.areWeOnClient(world);
    }

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation("omnis", path);
    }

    public static <T> ArrayList<T> toArrayList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    public static <T> ArrayList<T> toArrayList(Stream<T> items) {
        return items.collect(Collectors.toCollection(ArrayList::new));
    }

    public static String toTitleCase(String givenString, String regex) {
        String[] stringArray = givenString.split(regex);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(Character.toUpperCase(string.charAt(0))).append(string.substring(1)).append(regex);
        }
        return stringBuilder.toString().trim().replaceAll(regex, " ").substring(0, stringBuilder.length() - 1);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Collection<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            return Collections.emptyList();
        }
        if (!src.removeAll(ret)) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }

    @Nonnull
    public static Optional<ImmutableTriple<String, Integer, ItemStack>> findCosmeticCurio(Predicate<ItemStack> filter, @Nonnull LivingEntity livingEntity) {
        ImmutableTriple result = CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(handler -> {
            Map curios = handler.getCurios();
            for (String id : curios.keySet()) {
                ItemStack stack;
                int i;
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(id);
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHelper = stacksHandler.getCosmeticStacks();
                for (i = 0; i < stackHandler.getSlots(); ++i) {
                    stack = stackHandler.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
                for (i = 0; i < cosmeticStackHelper.getSlots(); ++i) {
                    stack = cosmeticStackHelper.getStackInSlot(i);
                    if (stack.func_190926_b() || !filter.test(stack)) continue;
                    return new ImmutableTriple((Object)id, (Object)i, (Object)stack);
                }
            }
            return new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a);
        }).orElse(new ImmutableTriple((Object)"", (Object)0, (Object)ItemStack.field_190927_a));
        return ((String)result.getLeft()).isEmpty() ? Optional.empty() : Optional.of(result);
    }
}

