/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis.common.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class OmnisLootModifier
extends LootModifier {
    private final float itemChance;
    private final int itemCount;
    private final int extraItemCount;
    private final Item item;

    public OmnisLootModifier(ILootCondition[] conditionsIn, float itemChance, int itemCount, int extraItemCount, Item item) {
        super(conditionsIn);
        this.itemChance = itemChance;
        this.itemCount = itemCount;
        this.extraItemCount = extraItemCount;
        this.item = item;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (context.func_216032_b().nextFloat() < this.itemChance || this.itemChance == 1.0f) {
            int count = this.itemCount + context.func_216032_b().nextInt(this.extraItemCount + 1);
            generatedLoot.add(new ItemStack((IItemProvider)this.item, count));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<OmnisLootModifier> {
        public OmnisLootModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            float itemChance = JSONUtils.func_151217_k((JsonObject)object, (String)"itemChance");
            int itemCount = JSONUtils.func_151203_m((JsonObject)object, (String)"itemCount");
            int extraItemCount = JSONUtils.func_151203_m((JsonObject)object, (String)"extraItemCount");
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"item")));
            return new OmnisLootModifier(conditionsIn, itemChance, itemCount, extraItemCount, item);
        }

        public JsonObject write(OmnisLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("itemChance", (Number)Float.valueOf(instance.itemChance));
            json.addProperty("itemCount", (Number)instance.itemCount);
            json.addProperty("extraItemCount", (Number)instance.extraItemCount);
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.item).toString());
            return json;
        }
    }
}

