/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis.core.data;

import com.sammy.omnis.OmnisHelper;
import com.sammy.omnis.core.init.OmnisBlocks;
import com.sammy.omnis.core.init.OmnisItems;
import com.sammy.omnis.core.init.OmnisSounds;
import com.sammy.omnis.core.init.Registries;
import com.sammy.omnis.core.init.effects.OmnisEffects;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraftforge.common.data.LanguageProvider;

public class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(DataGenerator gen) {
        super(gen, "omnis", "en_us");
    }

    protected void addTranslations() {
        HashSet blocks = new HashSet(OmnisBlocks.BLOCKS.getEntries());
        HashSet items = new HashSet(OmnisItems.ITEMS.getEntries());
        HashSet sounds = new HashSet(OmnisSounds.SOUNDS.getEntries());
        HashSet enchantments = new HashSet(Registries.ENCHANTMENTS.getEntries());
        HashSet effects = new HashSet(OmnisEffects.EFFECTS.getEntries());
        OmnisHelper.takeAll(items, i -> i.get() instanceof BlockItem);
        OmnisHelper.takeAll(blocks, i -> i.get() instanceof WallTorchBlock);
        blocks.forEach(b -> {
            String name = ((Block)b.get()).func_149739_a().replaceFirst("block.omnis.", "");
            name = OmnisHelper.toTitleCase(this.specialBlockNameChanges(name), "_");
            this.add(((Block)b.get()).func_149739_a(), name);
        });
        items.forEach(i -> {
            if (!(i.get() instanceof BlockItem)) {
                String name = ((Item)i.get()).func_77658_a().replaceFirst("item.omnis.", "");
                name = OmnisHelper.toTitleCase(this.specialBlockNameChanges(name), "_");
                this.add(((Item)i.get()).func_77658_a(), name);
            }
        });
        sounds.forEach(s -> {
            String name = OmnisHelper.toTitleCase(s.getId().func_110623_a(), "_");
            this.add("omnis.subtitle." + s.getId().func_110623_a(), name);
        });
        enchantments.forEach(e -> {
            String name = OmnisHelper.toTitleCase(e.getId().func_110623_a(), "_");
            this.add(((Enchantment)e.get()).func_77320_a(), name);
        });
        effects.forEach(e -> {
            String name = OmnisHelper.toTitleCase(e.getId().func_110623_a(), "_");
            this.add("effect.omnis." + ((Effect)e.get()).getRegistryName().func_110623_a(), name);
        });
        this.addTooltip("haunted_armor", "+1 Magic Resistance");
        this.addTooltip("amplified_arcana", "Amplified Arcana");
        this.addTooltip("amplified_arcana_detailed", "Increases magic damage by a flat amount");
        this.addTooltip("ravage", "Ravage");
        this.addTooltip("ravage_detailed", "Greatly increased damage against illagers and players");
        this.addTooltip("arcane", "Arcane");
        this.addTooltip("arcane_detailed", "Deals both magic and physical damage with each swing");
        this.addTooltip("staggering", "Staggering");
        this.addTooltip("staggering_detailed", "This weapon staggers enemies on the first attack\nStaggered enemies deal less damage and have decreased armor");
        this.addTooltip("stunning", "Stunning");
        this.addTooltip("stunning_detailed", "This weapon stuns enemies on the first attack\nStunned enemies move slower and have decreased range");
        this.addTooltip("crushing", "Crushing");
        this.addTooltip("crushing_detailed", "This weapon deals more damage on the first attack");
        this.addTooltip("sweeping", "Sweeping");
        this.addTooltip("sweeping_detailed", "Every attack from this weapon causes a strong sweep attack");
        this.addTooltip("outlying", "Outlying");
        this.addTooltip("outlying_detailed", "Deals more damage to faraway enemies");
        this.add("item.minecraft.potion.effect.magic_proficiency", "Potion of Magic Proficiency");
        this.add("item.minecraft.potion.effect.long_magic_proficiency", "Potion of Magic Proficiency");
        this.add("item.minecraft.potion.effect.strong_magic_proficiency", "Potion of Magic Proficiency");
        this.add("item.minecraft.splash_potion.effect.magic_proficiency", "Splash Potion of Magic Proficiency");
        this.add("item.minecraft.splash_potion.effect.long_magic_proficiency", "Splash Potion of Magic Proficiency");
        this.add("item.minecraft.splash_potion.effect.strong_magic_proficiency", "Splash Potion of Magic Proficiency");
        this.add("item.minecraft.lingering_potion.effect.magic_proficiency", "Lingering Potion of Magic Proficiency");
        this.add("item.minecraft.lingering_potion.effect.long_magic_proficiency", "Lingering Potion of Magic Proficiency");
        this.add("item.minecraft.lingering_potion.effect.strong_magic_proficiency", "Lingering Potion of Magic Proficiency");
        this.add("item.minecraft.tipped_arrow.effect.magic_proficiency", "Arrow of Magic Proficiency");
        this.add("item.minecraft.tipped_arrow.effect.long_magic_proficiency", "Arrow of Magic Proficiency");
        this.add("item.minecraft.tipped_arrow.effect.strong_magic_proficiency", "Arrow of Magic Proficiency");
        this.add("itemGroup.omnis", "Omnis ");
    }

    public String func_200397_b() {
        return "Lang Entries";
    }

    public void addTooltip(String identifier, String tooltip) {
        this.add("omnis.tooltip." + identifier, tooltip);
    }

    public String specialBlockNameChanges(String name) {
        if (!name.endsWith("_bricks") && name.contains("bricks")) {
            name = name.replaceFirst("bricks", "brick");
        }
        if ((name.contains("_fence") || name.contains("_button")) && name.contains("planks")) {
            name = name.replaceFirst("_planks", "");
        }
        return name;
    }
}

