/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.omnis.core.data;

import com.mojang.datafixers.util.Pair;
import com.sammy.omnis.OmnisHelper;
import com.sammy.omnis.common.blocks.VexwartBlock;
import com.sammy.omnis.core.init.OmnisBlocks;
import com.sammy.omnis.core.init.OmnisItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.BlockPredicate;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.AlternativesLootEntry;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.IntClamper;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.LocationCheck;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.CopyBlockState;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LimitCount;
import net.minecraft.loot.functions.SetContents;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class ModLootTableProvider
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = new ArrayList<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>>();
    private static final Set<Item> IMMUNE_TO_EXPLOSIONS = Collections.emptySet();
    private static final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
    private static final ILootCondition.IBuilder SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ));
    private static final ILootCondition.IBuilder SILK_TOUCH_OR_SHEARS = SHEARS.func_216297_a(SILK_TOUCH);
    private static final ILootCondition.IBuilder NOT_SILK_TOUCH_OR_SHEARS = SILK_TOUCH_OR_SHEARS.func_216298_a();
    private static final float[] RARE_SAPLING_DROP_RATES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};

    public ModLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    public String func_200397_b() {
        return "Loot Tables";
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((loc, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)loc, (LootTable)table));
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        HashSet blocks = new HashSet(OmnisBlocks.BLOCKS.getEntries());
        blocks.remove(OmnisBlocks.VEXWART);
        this.registerLootTable((Block)OmnisBlocks.VEXWART.get(), ModLootTableProvider.vexwartDropping((Block)OmnisBlocks.VEXWART.get(), (Item)OmnisItems.VEXWART.get()));
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof WallTorchBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof LeavesBlock);
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof DoublePlantBlock).forEach(b -> this.registerLootTable((Block)b.get(), ModLootTableProvider.onlyWithShears((IItemProvider)((Block)b.get()).func_199767_j())));
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof GrassBlock).forEach(b -> this.registerLootTable((Block)b.get(), ModLootTableProvider.droppingWithSilkTouch((Block)b.get(), (IItemProvider)Items.field_221582_j)));
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof SlabBlock).forEach(b -> this.registerLootTable((Block)b.get(), ModLootTableProvider.droppingSlab((Block)b.get())));
        OmnisHelper.takeAll(blocks, b -> b.get() instanceof DoorBlock).forEach(b -> this.registerLootTable((Block)b.get(), ModLootTableProvider.droppingDoor((Block)b.get())));
        OmnisHelper.takeAll(blocks, b -> true).forEach(b -> this.registerLootTable((Block)b.get(), ModLootTableProvider.dropping((IItemProvider)((Block)b.get()).func_199767_j())));
        return this.tables;
    }

    protected static <T> T withExplosionDecay(IItemProvider item, ILootFunctionConsumer<T> function) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(item.func_199767_j()) ? function.func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()) : function.func_212862_c_());
    }

    protected static <T> T withSurvivesExplosion(IItemProvider item, ILootConditionConsumer<T> condition) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(item.func_199767_j()) ? condition.func_212840_b_(SurvivesExplosion.func_215968_b()) : condition.func_212862_c_());
    }

    protected static LootTable.Builder dropping(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModLootTableProvider.withSurvivesExplosion(item, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item))));
    }

    protected static LootTable.Builder dropping(Block block, ILootCondition.IBuilder conditionBuilder, LootEntry.Builder<?> p_218494_2_) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(conditionBuilder)).func_216080_a(p_218494_2_)));
    }

    protected static LootTable.Builder droppingWithSilkTouch(Block block, LootEntry.Builder<?> builder) {
        return ModLootTableProvider.dropping(block, SILK_TOUCH, builder);
    }

    protected static LootTable.Builder droppingWithShears(Block block, LootEntry.Builder<?> noShearAlternativeEntry) {
        return ModLootTableProvider.dropping(block, SHEARS, noShearAlternativeEntry);
    }

    protected static LootTable.Builder droppingWithSilkTouchOrShears(Block block, LootEntry.Builder<?> alternativeLootEntry) {
        return ModLootTableProvider.dropping(block, SILK_TOUCH_OR_SHEARS, alternativeLootEntry);
    }

    protected static LootTable.Builder droppingWithSilkTouch(Block block, IItemProvider noSilkTouch) {
        return ModLootTableProvider.droppingWithSilkTouch(block, (LootEntry.Builder)ModLootTableProvider.withSurvivesExplosion((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)noSilkTouch)));
    }

    protected static LootTable.Builder vexwartDropping(Block vexWart, Item item) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)vexWart, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)item).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)vexWart).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)VexwartBlock.field_176486_a, 0)))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)item).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)vexWart).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)VexwartBlock.field_176486_a, 1)))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)item).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)vexWart).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)VexwartBlock.field_176486_a, 2)))).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)4.0f))).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)vexWart).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)VexwartBlock.field_176486_a, 3)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)OmnisItems.TEAR_OF_VEX.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)vexWart).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)VexwartBlock.field_176486_a, 3)))))));
    }

    protected static LootTable.Builder droppingRandomly(IItemProvider item, IRandomRange range) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ModLootTableProvider.withExplosionDecay(item, ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)range)))));
    }

    protected static LootTable.Builder droppingWithSilkTouchOrRandomly(Block block, IItemProvider item, IRandomRange range) {
        return ModLootTableProvider.droppingWithSilkTouch(block, (LootEntry.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)range))));
    }

    protected static LootTable.Builder onlyWithSilkTouchOrShears(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(SILK_TOUCH_OR_SHEARS).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)));
    }

    protected static LootTable.Builder onlyWithSilkTouch(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(SILK_TOUCH).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)));
    }

    protected static LootTable.Builder droppingAndFlowerPot(IItemProvider flower) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModLootTableProvider.withSurvivesExplosion((IItemProvider)Blocks.field_150457_bL, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_150457_bL)))).func_216040_a((LootPool.Builder)ModLootTableProvider.withSurvivesExplosion(flower, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)flower))));
    }

    protected static LootTable.Builder droppingSlab(Block slab) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)slab, ItemLootEntry.func_216168_a((IItemProvider)slab).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)slab).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))))));
    }

    protected static <T extends Comparable<T> & IStringSerializable> LootTable.Builder droppingWhen(Block block, Property<T> property, T value) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModLootTableProvider.withSurvivesExplosion((IItemProvider)block, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(property, value))))));
    }

    protected static LootTable.Builder droppingWithName(Block block) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModLootTableProvider.withSurvivesExplosion((IItemProvider)block, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)))));
    }

    protected static LootTable.Builder droppingWithContents(Block shulker) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModLootTableProvider.withSurvivesExplosion((IItemProvider)shulker, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)shulker).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Lock", "BlockEntityTag.Lock").func_216056_a("LootTable", "BlockEntityTag.LootTable").func_216056_a("LootTableSeed", "BlockEntityTag.LootTableSeed")).func_212841_b_((ILootFunction.IBuilder)SetContents.func_215920_b().func_216075_a((LootEntry.Builder)DynamicLootEntry.func_216162_a((ResourceLocation)ShulkerBoxBlock.field_220169_b))))));
    }

    protected static LootTable.Builder droppingWithPatterns(Block banner) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModLootTableProvider.withSurvivesExplosion((IItemProvider)banner, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)banner).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Patterns", "BlockEntityTag.Patterns")))));
    }

    private static LootTable.Builder droppingAndBees(Block nest) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(SILK_TOUCH).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)nest).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Bees", "BlockEntityTag.Bees")).func_212841_b_((ILootFunction.IBuilder)CopyBlockState.func_227545_a_((Block)nest).func_227552_a_((Property)BeehiveBlock.field_226873_c_))));
    }

    private static LootTable.Builder droppingAndBeesWithAlternative(Block hive) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)hive).func_212840_b_(SILK_TOUCH)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Bees", "BlockEntityTag.Bees")).func_212841_b_((ILootFunction.IBuilder)CopyBlockState.func_227545_a_((Block)hive).func_227552_a_((Property)BeehiveBlock.field_226873_c_)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)hive))));
    }

    protected static LootTable.Builder droppingItemWithFortune(Block block, Item item) {
        return ModLootTableProvider.droppingWithSilkTouch(block, (LootEntry.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))));
    }

    protected static LootTable.Builder droppingItemRarely(Block block, IItemProvider item) {
        return ModLootTableProvider.droppingWithSilkTouch(block, (LootEntry.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)-6.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LimitCount.func_215911_a((IntClamper)IntClamper.func_215848_a((int)0)))));
    }

    protected static LootTable.Builder droppingSeeds(Block block) {
        return ModLootTableProvider.droppingWithShears(block, (LootEntry.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)block, ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151014_N).func_212840_b_(RandomChance.func_216004_a((float)0.125f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)2))));
    }

    protected static LootTable.Builder droppingByAge(Block stemFruit, Item item) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)stemFruit, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.06666667f)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)stemFruit).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)StemBlock.field_176484_a, 0)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.13333334f)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)stemFruit).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)StemBlock.field_176484_a, 1)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.2f)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)stemFruit).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)StemBlock.field_176484_a, 2)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.26666668f)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)stemFruit).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)StemBlock.field_176484_a, 3)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.33333334f)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)stemFruit).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)StemBlock.field_176484_a, 4)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.4f)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)stemFruit).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)StemBlock.field_176484_a, 5)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.46666667f)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)stemFruit).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)StemBlock.field_176484_a, 6)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.53333336f)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)stemFruit).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)StemBlock.field_176484_a, 7)))))));
    }

    private static LootTable.Builder dropSeedsForStem(Block stem, Item stemSeed) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)stem, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)stemSeed).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)BinomialRange.func_215838_a((int)3, (float)0.53333336f))))));
    }

    protected static LootTable.Builder onlyWithShears(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SHEARS).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)));
    }

    protected static LootTable.Builder droppingWithChancesAndSticks(Block block, Block sapling, float ... chances) {
        return ModLootTableProvider.droppingWithSilkTouchOrShears(block, ((StandaloneLootEntry.Builder)ModLootTableProvider.withSurvivesExplosion((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)sapling))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])chances))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)Items.field_151055_y).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
    }

    protected static LootTable.Builder droppingWithChancesSticksAndApples(Block block, Block sapling, float ... chances) {
        return ModLootTableProvider.droppingWithChancesAndSticks(block, sapling, chances).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)ModLootTableProvider.withSurvivesExplosion((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)Items.field_151034_e))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    protected static LootTable.Builder droppingAndBonusWhen(Block block, Item itemConditional, Item withBonus, ILootCondition.IBuilder conditionBuilder) {
        return (LootTable.Builder)ModLootTableProvider.withExplosionDecay((IItemProvider)block, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)itemConditional).func_212840_b_(conditionBuilder)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)withBonus)))).func_216040_a(LootPool.func_216096_a().func_212840_b_(conditionBuilder).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)withBonus).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3)))));
    }

    private static LootTable.Builder droppingSheared(Block sheared) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(SHEARS).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)sheared).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)))));
    }

    private static LootTable.Builder droppingSeedsTall(Block block, Block sheared) {
        AlternativesLootEntry.Builder builder = ((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)sheared).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2))).func_212840_b_(SHEARS)).func_216080_a(((StandaloneLootEntry.Builder)ModLootTableProvider.withSurvivesExplosion((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)Items.field_151014_N))).func_212840_b_(RandomChance.func_216004_a((float)0.125f)));
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)builder).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER))).func_212840_b_(LocationCheck.func_241547_a_((LocationPredicate.Builder)LocationPredicate.Builder.func_226870_a_().func_235312_a_(BlockPredicate.Builder.func_226243_a_().func_233458_a_(block).func_233459_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).func_227196_b_()).func_226245_b_()), (BlockPos)new BlockPos(0, 1, 0)))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)builder).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER))).func_212840_b_(LocationCheck.func_241547_a_((LocationPredicate.Builder)LocationPredicate.Builder.func_226870_a_().func_235312_a_(BlockPredicate.Builder.func_226243_a_().func_233458_a_(block).func_233459_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).func_227196_b_()).func_226245_b_()), (BlockPos)new BlockPos(0, -1, 0))));
    }

    public static LootTable.Builder blockNoDrop() {
        return LootTable.func_216119_b();
    }

    private void droppingNetherVines(Block vines, Block plant) {
        LootTable.Builder loottable$builder = ModLootTableProvider.droppingWithSilkTouchOrShears(vines, ItemLootEntry.func_216168_a((IItemProvider)vines).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f})));
        this.registerLootTable(vines, loottable$builder);
        this.registerLootTable(plant, loottable$builder);
    }

    public static LootTable.Builder droppingDoor(Block door) {
        return ModLootTableProvider.droppingWhen(door, DoorBlock.field_176523_O, DoubleBlockHalf.LOWER);
    }

    private static StandaloneLootEntry.Builder<?> itemEntry(Item item, int weight) {
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight);
    }

    protected void registerLootTable(Block blockIn, LootTable.Builder table) {
        this.addTable(blockIn.func_220068_i(), table);
    }

    void addTable(ResourceLocation path, LootTable.Builder lootTable) {
        this.addTable(path, lootTable, LootParameterSets.field_216267_h);
    }

    void addTable(ResourceLocation path, LootTable.Builder lootTable, LootParameterSet lootParameterSet) {
        this.tables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>)Pair.of(() -> lootBuilder -> lootBuilder.accept(path, lootTable), (Object)lootParameterSet));
    }
}

