/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries;

import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.MD5Util;
import com.mohistmc.util.i18n.i18n;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class DefaultLibraries {
    private static int retry = 0;
    public static HashMap<String, String> fail = new HashMap();

    public static void run() throws Exception {
        System.out.println(i18n.get("libraries.checking.start"));
        String url = "https://maven.mohistmc.com/";
        LinkedHashMap<File, String> libs = DefaultLibraries.getDefaultLibs();
        for (File file : DefaultLibraries.getDefaultLibs().keySet()) {
            if (file.exists() && (MD5Util.getMd5(file).equals(libs.get(file)) || MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(file.getName()))) continue;
            file.getParentFile().mkdirs();
            String u = url + "libraries/" + file.getAbsolutePath().replaceAll("\\\\", "/").split("/libraries/")[1];
            System.out.println(i18n.get("libraries.global.percentage") + String.valueOf((float)UpdateUtils.getSizeOfDirectory(new File(JarTool.getJarDir() + "/libraries")) / 57.0f * 100.0f).substring(0, 2).replace(".", "") + "%");
            try {
                UpdateUtils.downloadFile(u, file);
                if (file.getName().endsWith(".jar") && !file.getName().contains("asm-tree-6.1.1.jar")) {
                    new JarLoader().loadJar(file);
                }
                fail.remove(u);
            }
            catch (Exception e) {
                System.out.println(i18n.get("file.download.nook", u));
                file.delete();
                fail.put(u, file.getAbsolutePath());
            }
        }
        if (retry < 3 && !fail.isEmpty()) {
            System.out.println(i18n.get("libraries.check.retry", ++retry));
            DefaultLibraries.run();
        } else {
            System.out.println(i18n.get("libraries.check.end"));
            if (!fail.isEmpty()) {
                System.out.println(i18n.get("libraries.check.missing"));
                for (String string : fail.keySet()) {
                    System.out.println("Link : " + string + "\nPath : " + fail.get(string) + "\n");
                }
                System.exit(0);
            }
        }
    }

    public static LinkedHashMap<File, String> getDefaultLibs() throws Exception {
        String str;
        LinkedHashMap<File, String> temp = new LinkedHashMap<File, String>();
        BufferedReader b = new BufferedReader(new InputStreamReader(DefaultLibraries.class.getClassLoader().getResourceAsStream("mohist_libraries.txt")));
        while ((str = b.readLine()) != null) {
            String[] s = str.split("\\|");
            temp.put(new File(JarTool.getJarDir() + "/" + s[0]), s[1]);
        }
        b.close();
        return temp;
    }
}

