/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.log4j;

import java.util.List;
import javax.annotation.Nullable;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="highlightMsg", category="Converter")
@ConverterKeys(value={"highlightMsg"})
@PerformanceSensitive(value={"allocation"})
public class HighlightMsgConverter
extends LogEventPatternConverter {
    private static final String ANSI_RESET = "\u001b[39;0m";
    private static final String ANSI_ERROR = "\u001b[31;1m";
    private static final String ANSI_WARN = "\u001b[33;1m";
    private static final String ANSI_INFO = "\u001b[39;0m";
    private static final String ANSI_FATAL = "\u001b[31;1m";
    private static final String ANSI_TRACE = "\u001b[31;1m";
    private final List<PatternFormatter> formatters;

    protected HighlightMsgConverter(List<PatternFormatter> formatters) {
        super("highlightMsg", null);
        this.formatters = formatters;
    }

    @Nullable
    public static HighlightMsgConverter newInstance(Configuration config, String[] options) {
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on highlightMsg. Expected 1 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on highlightMsg");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser((Configuration)config);
        List formatters = parser.parse(options[0]);
        return new HighlightMsgConverter(formatters);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (TerminalConsoleAppender.isAnsiSupported()) {
            Level level = event.getLevel();
            if (level.isMoreSpecificThan(Level.ERROR)) {
                this.format("\u001b[31;1m", event, toAppendTo);
                return;
            }
            if (level.isMoreSpecificThan(Level.WARN)) {
                this.format(ANSI_WARN, event, toAppendTo);
                return;
            }
            if (level.isMoreSpecificThan(Level.INFO)) {
                this.format("\u001b[39;0m", event, toAppendTo);
                return;
            }
            if (level.isMoreSpecificThan(Level.FATAL)) {
                this.format("\u001b[31;1m", event, toAppendTo);
                return;
            }
            if (level.isMoreSpecificThan(Level.TRACE)) {
                this.format("\u001b[31;1m", event, toAppendTo);
                return;
            }
        }
        int size = this.formatters.size();
        for (int i = 0; i < size; ++i) {
            this.formatters.get(i).format(event, toAppendTo);
        }
    }

    private void format(String style, LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        toAppendTo.append(style);
        int end = toAppendTo.length();
        int size = this.formatters.size();
        for (int i = 0; i < size; ++i) {
            this.formatters.get(i).format(event, toAppendTo);
        }
        if (toAppendTo.length() == end) {
            toAppendTo.setLength(start);
        } else {
            toAppendTo.append("\u001b[39;0m");
        }
    }

    public boolean handlesThrowable() {
        for (PatternFormatter formatter : this.formatters) {
            if (!formatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }
}

