/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mohistmc.MohistMCStart;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.network.download.NetworkUtil;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.i18n.i18n;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Stream;

public class UpdateUtils {
    private static int percentage = 0;

    public static void versionCheck() {
        System.out.println(i18n.get("update.check"));
        System.out.println(i18n.get("update.stopcheck"));
        try {
            JsonElement root = new JsonParser().parse((Reader)new InputStreamReader(NetworkUtil.getInput("https://ci.codemc.io/job/MohistMC/job/Mohist-1.16.5/lastSuccessfulBuild/api/json")));
            String jar_sha = MohistMCStart.getVersion();
            String build_number = "1.16.5-" + root.getAsJsonObject().get("number").toString();
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(Long.parseLong(root.getAsJsonObject().get("timestamp").toString())));
            if (jar_sha.equals(build_number)) {
                System.out.println(i18n.get("update.latest", "1.0", jar_sha, build_number));
            } else {
                System.out.println(i18n.get("update.detect", build_number, jar_sha, time));
                if (MohistConfigUtil.bMohist("check_update_auto_download", "false").booleanValue()) {
                    UpdateUtils.downloadFile("https://ci.codemc.io/job/MohistMC/job/Mohist-1.16.5/lastSuccessfulBuild/artifact/projects/mohist/build/libs/mohist-" + build_number + "-server.jar", JarTool.getFile());
                    UpdateUtils.restartServer(new ArrayList<String>(Arrays.asList("java", "-jar", JarTool.getJarName())), true);
                }
            }
        }
        catch (Throwable e) {
            System.out.println(i18n.get("check.update.noci"));
        }
    }

    public static void downloadFile(String URL2, final File f) throws Exception {
        URLConnection conn = NetworkUtil.getConn(URL2);
        System.out.println(i18n.get("download.file", f.getName(), UpdateUtils.getSize(conn.getContentLength())));
        final ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
        FileChannel fc = FileChannel.open(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        final int fS = conn.getContentLength();
        final Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (rbc.isOpen()) {
                    if (percentage != Math.round((float)f.length() / (float)fS * 100.0f) && percentage < 100) {
                        System.out.println(i18n.get("file.download.percentage", f.getName(), percentage));
                    }
                    percentage = Math.round((float)f.length() / (float)fS * 100.0f);
                } else {
                    t.cancel();
                }
            }
        }, 3000L, 1000L);
        fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
        fc.close();
        rbc.close();
        System.out.println(i18n.get("download.file.ok", f.getName()));
        percentage = 0;
    }

    public static void restartServer(ArrayList<String> cmd, boolean shutdown) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process process = processBuilder.start();
        process.waitFor();
        Thread.sleep(2000L);
        if (shutdown) {
            System.exit(0);
        }
    }

    public static String getSize(long size) {
        return size >= 0x100000L ? (float)size / 1048576.0f + "MB" : (size >= 1024L ? (float)size / 1024.0f + " KB" : size + " B");
    }

    public static long getSizeOfDirectory(File path) throws IOException {
        return ((Stream)Files.walk(path.toPath(), new FileVisitOption[0]).parallel()).filter(p -> !p.toFile().isDirectory()).count();
    }
}

