/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.mohistmc.util.i18n.i18n;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FMLConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static FMLConfig INSTANCE = new FMLConfig();
    private static ConfigSpec configSpec = new ConfigSpec();
    private CommentedFileConfig configData;

    private void loadFrom(Path configFile) {
        this.configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configFile).sync().defaultResource("/META-INF/defaultfmlconfig.toml").autosave().autoreload().writingMode(WritingMode.REPLACE).build();
        try {
            this.configData.load();
        }
        catch (ParsingException e) {
            throw new RuntimeException(i18n.get("fmlconfig.1") + configFile.toString(), e);
        }
        if (!configSpec.isCorrect((Config)this.configData)) {
            LOGGER.warn(LogMarkers.CORE, i18n.get("fmlconfig.2", configFile));
            configSpec.correct((Config)this.configData, (action, path, incorrectValue, correctedValue) -> LOGGER.warn(LogMarkers.CORE, i18n.get("fmlconfig.3", path, incorrectValue, correctedValue)));
        }
        this.configData.save();
    }

    public static void load() {
        Path configFile = FMLPaths.FMLCONFIG.get();
        INSTANCE.loadFrom(configFile);
        LOGGER.trace(LogMarkers.CORE, i18n.get("fmlconfig.4", FMLPaths.FMLCONFIG.get()));
        LOGGER.trace(LogMarkers.CORE, i18n.get("fmlconfig.5", FMLConfig.splashScreenEnabled()));
        LOGGER.trace(LogMarkers.CORE, i18n.get("fmlconfig.6", FMLConfig.loadingThreadCount()));
        LOGGER.trace(LogMarkers.CORE, i18n.get("fmlconfig.7", FMLConfig.runVersionCheck()));
        LOGGER.trace(LogMarkers.CORE, i18n.get("fmlconfig.8", FMLConfig.defaultConfigPath()));
        FMLPaths.getOrCreateGameRelativePath(Paths.get(FMLConfig.defaultConfigPath(), new String[0]), "default config directory");
    }

    public static boolean splashScreenEnabled() {
        return FMLConfig.INSTANCE.configData.getOptional("splashscreen").orElse(Boolean.FALSE);
    }

    public static int loadingThreadCount() {
        int val = FMLConfig.INSTANCE.configData.getOptional("maxThreads").orElse(-1);
        if (val <= 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return val;
    }

    public static boolean runVersionCheck() {
        return FMLConfig.INSTANCE.configData.getOptional("versionCheck").orElse(Boolean.FALSE);
    }

    public static String defaultConfigPath() {
        return FMLConfig.INSTANCE.configData.getOptional("defaultConfigPath").orElse("defaultconfigs");
    }

    static {
        configSpec.define("splashscreen", (Object)Boolean.TRUE);
        configSpec.define("maxThreads", (Object)-1);
        configSpec.define("versionCheck", (Object)Boolean.TRUE);
        configSpec.define("defaultConfigPath", (Object)"defaultconfigs");
    }
}

