/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server;

import com.mohistmc.MohistMCStart;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.network.download.DownloadJava;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.i18n.i18n;
import cpw.mods.modlauncher.InvalidLauncherSetupException;
import cpw.mods.modlauncher.Launcher;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ServerMain {
    public static String[] mainArgs = null;

    public static void main(String[] args) {
        mainArgs = args;
        String path = JarTool.getJarPath();
        if (path != null && (path.contains("+") || path.contains("!"))) {
            System.out.println("[Mohist - ERROR] Unsupported characters have been detected in your server path. \nPlease remove + or ! in your server's folder name (in the folder which contains this character).\nPath : " + path);
            System.exit(0);
        }
        if (Float.parseFloat(System.getProperty("java.class.version")) < 55.0f || MohistConfigUtil.bMohist("use_custom_java11", "false").booleanValue()) {
            if (!DownloadJava.javabin.exists()) {
                System.err.println(i18n.get("oldjava.notify"));
            }
            try {
                DownloadJava.run();
            }
            catch (Exception ex) {
                System.err.println(i18n.get("oldjava.exception"));
                ex.printStackTrace();
                System.exit(1);
            }
        }
        try {
            MohistMCStart.main();
            Class.forName("cpw.mods.modlauncher.Launcher", false, ClassLoader.getSystemClassLoader());
            Class.forName("net.minecraftforge.forgespi.Environment", false, ClassLoader.getSystemClassLoader());
        }
        catch (Exception cnfe) {
            System.err.println(i18n.get("mohist.start.server.error"));
            System.exit(1);
        }
        String launchArgs = Optional.ofNullable(ServerMain.class.getProtectionDomain()).map(ProtectionDomain::getCodeSource).map(CodeSource::getLocation).map(ServerMain::urlToManifest).map(Manifest::getMainAttributes).map(a -> a.getValue("ServerLaunchArgs")).orElseThrow(ServerMain::throwMissingManifest);
        String[] defaultargs = launchArgs.split(" ");
        String[] result = new String[args.length + defaultargs.length];
        System.arraycopy(defaultargs, 0, result, 0, defaultargs.length);
        System.arraycopy(args, 0, result, defaultargs.length, args.length);
        new Runner().runLauncher(result);
    }

    private static Manifest urlToManifest(URL url) {
        try {
            return new JarFile(new File(url.toURI())).getManifest();
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
    }

    private static RuntimeException throwMissingManifest() {
        System.err.println("This is not being run from a valid JAR file, essential data is missing.");
        return new RuntimeException("Missing the manifest");
    }

    private static class Runner {
        private Runner() {
        }

        private void runLauncher(String[] result) {
            try {
                Launcher.main((String[])result);
            }
            catch (InvalidLauncherSetupException e) {
                System.err.println("The server is missing critical libraries and cannot load. Please run the installer to correct this");
                System.exit(1);
            }
        }
    }
}

