/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.AdvancementModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public final class RewardsModifier
extends AdvancementModifier<Config> {
    public RewardsModifier() {
        super((element, conditionArrayParser) -> {
            JsonObject object = element.getAsJsonObject();
            AdvancementModifier.Mode mode = AdvancementModifier.Mode.deserialize(object);
            Optional<Integer> experience = JSONUtils.func_151204_g((JsonObject)object, (String)"experience") ? Optional.of(JSONUtils.func_151203_m((JsonObject)object, (String)"experience")) : Optional.empty();
            Optional<List<ResourceLocation>> loot = RewardsModifier.deserializeResourceList(object, "loot");
            Optional<List<ResourceLocation>> recipes = RewardsModifier.deserializeResourceList(object, "recipes");
            Optional<ResourceLocation> function = JSONUtils.func_151204_g((JsonObject)object, (String)"function") ? Optional.of(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"function"))) : Optional.empty();
            return new Config(mode, experience, loot, recipes, function);
        });
    }

    private static Optional<List<ResourceLocation>> deserializeResourceList(JsonObject object, String key) {
        if (JSONUtils.func_151204_g((JsonObject)object, (String)key)) {
            ArrayList resourceLocations = Lists.newArrayList();
            object.getAsJsonArray(key).forEach(element -> resourceLocations.add(new ResourceLocation(element.getAsString())));
            return Optional.of(resourceLocations);
        }
        return Optional.empty();
    }

    @Override
    public void modify(Advancement.Builder builder, Config config) {
        if (config.mode == AdvancementModifier.Mode.MODIFY) {
            AdvancementRewards rewards = builder.field_192064_d;
            AdvancementRewards.Builder rewardsBuilder = new AdvancementRewards.Builder();
            rewardsBuilder.func_203906_b(rewards.field_192115_b);
            rewardsBuilder.field_200283_b.addAll(Arrays.asList(rewards.field_192116_c));
            for (ResourceLocation recipe : rewards.field_192117_d) {
                rewardsBuilder.func_200279_d(recipe);
            }
            rewardsBuilder.field_200285_d = rewards.field_193129_e.func_200376_a();
            config.experience.ifPresent(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).func_203906_b(arg_0));
            config.loot.ifPresent(rewardsBuilder.field_200283_b::addAll);
            config.recipes.ifPresent(rewardsBuilder.field_200284_c::addAll);
            config.function.ifPresent(function -> {
                rewardsBuilder.field_200285_d = function;
            });
            builder.func_200271_a(rewardsBuilder);
        } else {
            AdvancementRewards.Builder rewardsBuilder = new AdvancementRewards.Builder();
            config.experience.ifPresent(arg_0 -> ((AdvancementRewards.Builder)rewardsBuilder).func_203906_b(arg_0));
            config.loot.ifPresent(loot -> {
                rewardsBuilder.field_200283_b.clear();
                rewardsBuilder.field_200283_b.addAll(loot);
            });
            config.recipes.ifPresent(recipes -> {
                rewardsBuilder.field_200284_c.clear();
                rewardsBuilder.field_200284_c.addAll(recipes);
            });
            config.function.ifPresent(function -> {
                rewardsBuilder.field_200285_d = function;
            });
            builder.func_200271_a(rewardsBuilder);
        }
    }

    static class Config {
        private final AdvancementModifier.Mode mode;
        private final Optional<Integer> experience;
        private final Optional<List<ResourceLocation>> loot;
        private final Optional<List<ResourceLocation>> recipes;
        private final Optional<ResourceLocation> function;

        Config(AdvancementModifier.Mode mode, Optional<Integer> experience, Optional<List<ResourceLocation>> loot, Optional<List<ResourceLocation>> recipes, Optional<ResourceLocation> function) {
            this.mode = mode;
            this.experience = experience;
            this.loot = loot;
            this.recipes = recipes;
            this.function = function;
        }
    }
}

