/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.world.modification;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModificationContext;
import com.minecraftabnormals.abnormals_core.common.world.modification.IBiomeModifier;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum BiomeModificationManager {
    INSTANCE;

    private final Set<IBiomeModifier> biomeModifiers = Sets.newHashSet();

    private BiomeModificationManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public synchronized void addModifier(IBiomeModifier biomeModifier) {
        this.biomeModifiers.add(biomeModifier);
    }

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeModificationContext context = BiomeModificationContext.create(event);
        if (context != null) {
            for (IBiomeModifier modifier : this.biomeModifiers) {
                if (!modifier.test(context)) continue;
                modifier.accept(context);
            }
        }
    }
}

