/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util;

import java.util.Random;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public final class MathUtil {
    public static Vector3d getCenterAdjusted(AxisAlignedBB bb, double xMultiplier, double yMultiplier, double zMultiplier) {
        return new Vector3d(bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) * xMultiplier, bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) * yMultiplier, bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) * zMultiplier);
    }

    public static double distanceBetweenPoints2d(double x1, double y1, double x2, double y2) {
        return MathHelper.func_76133_a((double)((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
    }

    public static double makeNegativeRandomly(double value, Random rand) {
        return rand.nextBoolean() ? -value : value;
    }

    public static double makeNegativeRandomlyWithFavoritism(double value, Random rand, float chance) {
        return rand.nextFloat() < chance ? -value : value;
    }

    public static int getLowestValueInIntArray(int[] array) {
        int currentLowest = Integer.MAX_VALUE;
        for (int value : array) {
            if (value > currentLowest) continue;
            currentLowest = value;
        }
        return currentLowest;
    }

    public static int getBrightLightForLight(int light) {
        return light >= 175 ? light : Math.abs(light - 240);
    }

    public static float invSqrt(float x) {
        float halfX = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - halfX * x * x;
        return x;
    }

    public static Vector3d lerp(Vector3d prev, Vector3d current, float ptc) {
        return prev.func_178787_e(current.func_178788_d(prev).func_186678_a((double)ptc));
    }

    public static class CatmullRomSpline {
        private final Vector3d[] points;
        private final float alpha;

        public CatmullRomSpline(Vector3d[] points, SplineType splineType) {
            this.points = points;
            this.alpha = splineType.getAlpha();
        }

        public BlockPos interpolate(float progress) {
            Vector3d[] points = this.points;
            float sections = points.length - 3;
            int currentPoint = (int)Math.min(Math.floor(progress * sections), (double)(sections - 1.0f));
            float alpha = this.alpha;
            Vector3d point0 = points[currentPoint];
            Vector3d point1 = points[currentPoint + 1];
            float t0 = CatmullRomSpline.computeT(point0, point1, alpha, 0.0f);
            Vector3d point2 = points[currentPoint + 2];
            Vector3d point3 = points[currentPoint + 3];
            float t1 = CatmullRomSpline.computeT(point1, point2, alpha, t0);
            float t = t0 + (progress * sections - (float)currentPoint) * (t1 - t0);
            double A1multiplier1 = (t0 - t) / t0;
            double A1multiplier2 = t / t0;
            double A1x = CatmullRomSpline.multiplyPoints(point0.field_72450_a, point1.field_72450_a, A1multiplier1, A1multiplier2);
            double A1y = CatmullRomSpline.multiplyPoints(point0.field_72448_b, point1.field_72448_b, A1multiplier1, A1multiplier2);
            double A1z = CatmullRomSpline.multiplyPoints(point0.field_72449_c, point1.field_72449_c, A1multiplier1, A1multiplier2);
            double A2Denominator = t1 - t0;
            double A2Multiplier1 = (double)(t1 - t) / A2Denominator;
            double A2Multiplier2 = (double)(t - t0) / A2Denominator;
            double A2x = CatmullRomSpline.multiplyPoints(point1.field_72450_a, point2.field_72450_a, A2Multiplier1, A2Multiplier2);
            double A2y = CatmullRomSpline.multiplyPoints(point1.field_72448_b, point2.field_72448_b, A2Multiplier1, A2Multiplier2);
            double A2z = CatmullRomSpline.multiplyPoints(point1.field_72449_c, point2.field_72449_c, A2Multiplier1, A2Multiplier2);
            float t3 = CatmullRomSpline.computeT(point2, point3, alpha, t1);
            double A3Denominator = t3 - t1;
            double A3Multiplier1 = (double)(t3 - t) / A3Denominator;
            double A3Multiplier2 = (double)(t - t1) / A3Denominator;
            double A3x = CatmullRomSpline.multiplyPoints(point2.field_72450_a, point3.field_72450_a, A3Multiplier1, A3Multiplier2);
            double A3y = CatmullRomSpline.multiplyPoints(point2.field_72448_b, point3.field_72448_b, A3Multiplier1, A3Multiplier2);
            double A3z = CatmullRomSpline.multiplyPoints(point2.field_72449_c, point3.field_72449_c, A3Multiplier1, A3Multiplier2);
            double B1Multiplier1 = (t1 - t) / t1;
            double B1Multiplier2 = t / t1;
            double B1x = CatmullRomSpline.multiplyPoints(A1x, A2x, B1Multiplier1, B1Multiplier2);
            double B1y = CatmullRomSpline.multiplyPoints(A1y, A2y, B1Multiplier1, B1Multiplier2);
            double B1z = CatmullRomSpline.multiplyPoints(A1z, A2z, B1Multiplier1, B1Multiplier2);
            double B2Denominator = t3 - t0;
            double B2Multiplier1 = (double)(t3 - t) / B2Denominator;
            double B2Multiplier2 = (double)(t - t0) / B2Denominator;
            double B2x = CatmullRomSpline.multiplyPoints(A2x, A3x, B2Multiplier1, B2Multiplier2);
            double B2y = CatmullRomSpline.multiplyPoints(A2y, A3y, B2Multiplier1, B2Multiplier2);
            double B2z = CatmullRomSpline.multiplyPoints(A2z, A3z, B2Multiplier1, B2Multiplier2);
            double CDenominator = t1 - t0;
            double CMultiplier1 = (double)(t1 - t) / CDenominator;
            double CMultiplier2 = (double)(t - t0) / CDenominator;
            return new BlockPos(CatmullRomSpline.multiplyPoints(B1x, B2x, CMultiplier1, CMultiplier2), CatmullRomSpline.multiplyPoints(B1y, B2y, CMultiplier1, CMultiplier2), CatmullRomSpline.multiplyPoints(B1z, B2z, CMultiplier1, CMultiplier2));
        }

        private static double multiplyPoints(double point1, double point2, double multiplier1, double multiplier2) {
            return point1 * multiplier1 + point2 * multiplier2;
        }

        private static float computeT(Vector3d point1, Vector3d point2, float alpha, float offset) {
            return (float)Math.pow(point2.func_178788_d(point1).func_72433_c(), alpha) + offset;
        }

        public static enum SplineType {
            STANDARD(0.0f),
            CENTRIPETAL(0.5f),
            CHORDAL(1.0f);

            private float alpha;

            private SplineType(float alpha) {
                this.alpha = alpha;
            }

            public float getAlpha() {
                return this.alpha;
            }
        }
    }

    @FunctionalInterface
    public static interface Equation {
        public double compute(double var1);
    }
}

