/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.item;

import com.minecraftabnormals.abnormals_core.core.mixin.ItemInvokerMixin;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;

public final class ItemStackUtil {
    private static final String[] M_NUMERALS = new String[]{"", "M", "MM", "MMM"};
    private static final String[] C_NUMERALS = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
    private static final String[] X_NUMERALS = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
    private static final String[] I_NUMERALS = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};

    public static int findIndexOfItem(Item item, NonNullList<ItemStack> items) {
        for (int i = 0; i < items.size(); ++i) {
            if (((ItemStack)items.get(i)).func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static void fillAfterItemForGroup(Item item, Item targetItem, ItemGroup group, NonNullList<ItemStack> items) {
        if (ItemStackUtil.isInGroup(item, group)) {
            int targetIndex = ItemStackUtil.findIndexOfItem(targetItem, items);
            if (targetIndex != -1) {
                items.add(targetIndex + 1, (Object)new ItemStack((IItemProvider)item));
            } else {
                items.add((Object)new ItemStack((IItemProvider)item));
            }
        }
    }

    public static String intToRomanNumerals(int number) {
        String thousands = M_NUMERALS[number / 1000];
        String hundreds = C_NUMERALS[number % 1000 / 100];
        String tens = X_NUMERALS[number % 100 / 10];
        String ones = I_NUMERALS[number % 10];
        return thousands + hundreds + tens + ones;
    }

    public static boolean isInGroup(Item item, @Nonnull ItemGroup group) {
        return ((ItemInvokerMixin)item).callIsInGroup(group);
    }
}

