/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.registry;

import com.minecraftabnormals.abnormals_core.client.ChestManager;
import com.minecraftabnormals.abnormals_core.client.renderer.ChestItemRenderer;
import com.minecraftabnormals.abnormals_core.common.blocks.chest.AbnormalsChestBlock;
import com.minecraftabnormals.abnormals_core.common.blocks.chest.AbnormalsTrappedChestBlock;
import com.minecraftabnormals.abnormals_core.common.blocks.sign.AbnormalsStandingSignBlock;
import com.minecraftabnormals.abnormals_core.common.blocks.sign.AbnormalsWallSignBlock;
import com.minecraftabnormals.abnormals_core.common.items.AbnormalsSignItem;
import com.minecraftabnormals.abnormals_core.common.items.FuelBlockItem;
import com.minecraftabnormals.abnormals_core.common.items.InjectedBlockItem;
import com.minecraftabnormals.abnormals_core.common.tileentity.AbnormalsChestTileEntity;
import com.minecraftabnormals.abnormals_core.common.tileentity.AbnormalsTrappedChestTileEntity;
import com.minecraftabnormals.abnormals_core.core.util.registry.AbstractSubRegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.ISubRegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import com.mojang.datafixers.util.Pair;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.item.TallBlockItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockSubRegistryHelper
extends AbstractSubRegistryHelper<Block> {
    protected final DeferredRegister<Item> itemRegister;

    public BlockSubRegistryHelper(RegistryHelper parent) {
        this(parent, parent.getSubHelper(ForgeRegistries.ITEMS).getDeferredRegister(), (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)parent.getModId()));
    }

    public BlockSubRegistryHelper(RegistryHelper parent, ISubRegistryHelper<Item> itemHelper) {
        this(parent, itemHelper.getDeferredRegister(), (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)parent.getModId()));
    }

    public BlockSubRegistryHelper(RegistryHelper parent, DeferredRegister<Item> itemRegister, DeferredRegister<Block> deferredRegister) {
        super(parent, deferredRegister);
        this.itemRegister = itemRegister;
    }

    public <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlockWithItem(String name, Supplier<? extends B> supplier, Supplier<BlockItem> item) {
        this.itemRegister.register(name, item);
        return this.deferredRegister.register(name, supplier);
    }

    public <B extends Block> RegistryObject<B> createBlockNoItem(String name, Supplier<? extends B> supplier) {
        return this.deferredRegister.register(name, supplier);
    }

    public <B extends Block> RegistryObject<B> createFuelBlock(String name, Supplier<? extends B> supplier, int burnTime, @Nullable ItemGroup group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createInjectedBlock(String name, Item followItem, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new InjectedBlockItem(followItem, (Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlockWithISTER(String name, Supplier<? extends B> supplier, Supplier<Callable<ItemStackTileEntityRenderer>> ister, @Nullable ItemGroup group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group).setISTER(ister)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createTallBlock(String name, Supplier<? extends B> supplier, ItemGroup group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new TallBlockItem((Block)block.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createWallOrFloorBlock(String name, Supplier<? extends B> supplier, Supplier<? extends B> wallSupplier, @Nullable ItemGroup group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new WallOrFloorItem((Block)block.get(), (Block)wallSupplier.get(), new Item.Properties().func_200916_a(group)));
        return block;
    }

    public <B extends Block> RegistryObject<B> createRareBlock(String name, Supplier<? extends B> supplier, Rarity rarity, @Nullable ItemGroup group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_208103_a(rarity).func_200916_a(group)));
        return block;
    }

    public RegistryObject<AbnormalsChestBlock> createChestBlock(String name, AbstractBlock.Properties properties, @Nullable ItemGroup group) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register(name + "_chest", () -> new AbnormalsChestBlock(modId + ":" + name, properties));
        ChestManager.putChestInfo(modId, name, false);
        this.itemRegister.register(name + "_chest", () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group).setISTER(() -> BlockSubRegistryHelper.chestISTER(false))));
        return block;
    }

    public RegistryObject<AbnormalsTrappedChestBlock> createTrappedChestBlock(String name, AbstractBlock.Properties properties, @Nullable ItemGroup group) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register(name + "_trapped_chest", () -> new AbnormalsTrappedChestBlock(modId + ":" + name + "_trapped", properties));
        ChestManager.putChestInfo(modId, name, true);
        this.itemRegister.register(name + "_trapped_chest", () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group).setISTER(() -> BlockSubRegistryHelper.chestISTER(true))));
        return block;
    }

    public Pair<RegistryObject<AbnormalsStandingSignBlock>, RegistryObject<AbnormalsWallSignBlock>> createSignBlock(String name, MaterialColor color) {
        ResourceLocation texture = new ResourceLocation(this.parent.getModId(), "textures/entity/signs/" + name + ".png");
        RegistryObject standing = this.deferredRegister.register(name + "_sign", () -> new AbnormalsStandingSignBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a), texture));
        RegistryObject wall = this.deferredRegister.register(name + "_wall_sign", () -> new AbnormalsWallSignBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).func_222379_b((Block)standing.get()), texture));
        this.itemRegister.register(name + "_sign", () -> new AbnormalsSignItem((Block)standing.get(), (Block)wall.get(), new Item.Properties().func_200917_a(16).func_200916_a(ItemGroup.field_78031_c)));
        return Pair.of((Object)standing, (Object)wall);
    }

    public <B extends Block> RegistryObject<B> createCompatBlock(String modId, String name, Supplier<? extends B> supplier, @Nullable ItemGroup group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a((ItemGroup)(ModList.get().isLoaded(modId) || modId == "indev" ? group : null))));
        return block;
    }

    public <B extends Block> RegistryObject<B> createCompatBlock(String name, Supplier<? extends B> supplier, @Nullable ItemGroup group, String ... modIds) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a((ItemGroup)(BlockSubRegistryHelper.areModsLoaded(modIds) ? group : null))));
        return block;
    }

    public <B extends Block> RegistryObject<B> createCompatFuelBlock(String modId, String name, Supplier<? extends B> supplier, int burnTime, @Nullable ItemGroup group) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties().func_200916_a((ItemGroup)(ModList.get().isLoaded(modId) || modId == "indev" ? group : null))));
        return block;
    }

    public <B extends Block> RegistryObject<B> createCompatFuelBlock(String name, Supplier<? extends B> supplier, int burnTime, @Nullable ItemGroup group, String ... modIds) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new FuelBlockItem((Block)block.get(), burnTime, new Item.Properties().func_200916_a((ItemGroup)(BlockSubRegistryHelper.areModsLoaded(modIds) ? group : null))));
        return block;
    }

    public Pair<RegistryObject<AbnormalsChestBlock>, RegistryObject<AbnormalsTrappedChestBlock>> createCompatChestBlocks(String compatModId, String name, MaterialColor color) {
        boolean isModLoaded = ModList.get().isLoaded(compatModId) || compatModId == "indev";
        ItemGroup chestGroup = isModLoaded ? ItemGroup.field_78031_c : null;
        ItemGroup trappedChestGroup = isModLoaded ? ItemGroup.field_78028_d : null;
        String modId = this.parent.getModId();
        String chestName = name + "_chest";
        String trappedChestName = name + "_trapped_chest";
        RegistryObject chest = this.deferredRegister.register(chestName, () -> new AbnormalsChestBlock(modId + ":" + name, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        RegistryObject trappedChest = this.deferredRegister.register(trappedChestName, () -> new AbnormalsTrappedChestBlock(modId + ":" + name + "_trapped", AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        this.itemRegister.register(chestName, () -> new FuelBlockItem((Block)chest.get(), 300, new Item.Properties().func_200916_a(chestGroup).setISTER(() -> BlockSubRegistryHelper.chestISTER(false))));
        this.itemRegister.register(trappedChestName, () -> new FuelBlockItem((Block)trappedChest.get(), 300, new Item.Properties().func_200916_a(trappedChestGroup).setISTER(() -> BlockSubRegistryHelper.chestISTER(true))));
        ChestManager.putChestInfo(modId, name, false);
        ChestManager.putChestInfo(modId, name, true);
        return Pair.of((Object)chest, (Object)trappedChest);
    }

    public Pair<RegistryObject<AbnormalsChestBlock>, RegistryObject<AbnormalsTrappedChestBlock>> createCompatChestBlocks(String name, MaterialColor color, String ... modIds) {
        boolean isInGroup = BlockSubRegistryHelper.areModsLoaded(modIds);
        ItemGroup chestGroup = isInGroup ? ItemGroup.field_78031_c : null;
        ItemGroup trappedChestGroup = isInGroup ? ItemGroup.field_78028_d : null;
        String modId = this.parent.getModId();
        String chestName = name + "_chest";
        String trappedChestName = name + "_trapped_chest";
        RegistryObject chest = this.deferredRegister.register(chestName, () -> new AbnormalsChestBlock(modId + ":" + name, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        RegistryObject trappedChest = this.deferredRegister.register(trappedChestName, () -> new AbnormalsTrappedChestBlock(modId + ":" + name + "_trapped", AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
        this.itemRegister.register(chestName, () -> new FuelBlockItem((Block)chest.get(), 300, new Item.Properties().func_200916_a(chestGroup).setISTER(() -> BlockSubRegistryHelper.chestISTER(false))));
        this.itemRegister.register(trappedChestName, () -> new FuelBlockItem((Block)trappedChest.get(), 300, new Item.Properties().func_200916_a(trappedChestGroup).setISTER(() -> BlockSubRegistryHelper.chestISTER(true))));
        ChestManager.putChestInfo(modId, name, false);
        ChestManager.putChestInfo(modId, name, true);
        return Pair.of((Object)chest, (Object)trappedChest);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> chestISTER(boolean trapped) {
        return () -> new ChestItemRenderer<TileEntity>(trapped ? AbnormalsTrappedChestTileEntity::new : AbnormalsChestTileEntity::new);
    }
}

