/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellPiece;

public final class Spell {
    private static final String TAG_VALID = "validSpell";
    public static final String TAG_SPELL_NAME = "spellName";
    public static final String TAG_UUID_MOST = "uuidMost";
    public static final String TAG_UUID_LEAST = "uuidLeast";
    public static final String TAG_MODS_REQUIRED = "modsRequired";
    public static final String TAG_MOD_NAME = "modName";
    public static final String TAG_MOD_VERSION = "modVersion";
    public final SpellGrid grid = new SpellGrid(this);
    public String name = "";
    public UUID uuid = UUID.randomUUID();

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        this.grid.draw(ms, buffers, light);
    }

    @Nullable
    public static Spell createFromNBT(CompoundNBT cmp) {
        if (cmp == null || !cmp.func_74767_n(TAG_VALID)) {
            return null;
        }
        Spell spell = new Spell();
        spell.readFromNBT(cmp);
        return spell;
    }

    public void readFromNBT(CompoundNBT cmp) {
        this.name = cmp.func_74779_i(TAG_SPELL_NAME);
        if (cmp.func_74764_b(TAG_UUID_MOST)) {
            long uuidMost = cmp.func_74763_f(TAG_UUID_MOST);
            long uuidLeast = cmp.func_74763_f(TAG_UUID_LEAST);
            if (this.uuid.getMostSignificantBits() != uuidMost || this.uuid.getLeastSignificantBits() != uuidLeast) {
                this.uuid = new UUID(uuidMost, uuidLeast);
            }
        }
        this.grid.readFromNBT(cmp);
    }

    public Set<String> getPieceNamespaces() {
        Set<String> temp = Collections.newSetFromMap(new HashMap());
        SpellPiece[][] spellPieceArray = this.grid.gridData;
        int n = spellPieceArray.length;
        for (int i = 0; i < n; ++i) {
            SpellPiece[] gridDatum;
            for (SpellPiece spellPiece : gridDatum = spellPieceArray[i]) {
                if (spellPiece == null) continue;
                temp.add(spellPiece.registryKey.func_110624_b());
            }
        }
        return temp;
    }

    public void writeToNBT(CompoundNBT cmp) {
        cmp.func_74757_a(TAG_VALID, true);
        cmp.func_74778_a(TAG_SPELL_NAME, this.name);
        ListNBT modList = new ListNBT();
        for (String namespace : this.getPieceNamespaces()) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a(TAG_MOD_NAME, namespace);
            if (ModList.get().getModContainerById(namespace).isPresent()) {
                nbt.func_74778_a(TAG_MOD_VERSION, ((ModContainer)ModList.get().getModContainerById(namespace).get()).getModInfo().getVersion().toString());
            }
            modList.add((Object)nbt);
        }
        cmp.func_218657_a(TAG_MODS_REQUIRED, (INBT)modList);
        cmp.func_74772_a(TAG_UUID_MOST, this.uuid.getMostSignificantBits());
        cmp.func_74772_a(TAG_UUID_LEAST, this.uuid.getLeastSignificantBits());
        this.grid.writeToNBT(cmp);
    }

    public Spell copy() {
        CompoundNBT cmp = new CompoundNBT();
        this.writeToNBT(cmp);
        return Spell.createFromNBT(cmp);
    }
}

