/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.lib.LibResources;

@Mod.EventBusSubscriber(modid="psi", value={Dist.CLIENT})
public class BookSoundHandler {
    private static final int[] SECRET_CODE = new int[]{81, 85, 65, 84, 49, 48, 50, 52};
    private static int nextLetter = 0;
    private static int bookTime = 0;

    private static boolean isBookOpen() {
        return Objects.equals(PatchouliAPI.instance.getOpenBookGui(), LibResources.PATCHOULI_BOOK);
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent evt) {
        if (bookTime > 0) {
            --bookTime;
        }
        if (!BookSoundHandler.isBookOpen()) {
            nextLetter = 0;
        }
    }

    @SubscribeEvent
    public static void handleInput(InputEvent.KeyInputEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (evt.getModifiers() == 0 && evt.getAction() == 1 && BookSoundHandler.isBookOpen()) {
            if (bookTime == 0 && evt.getKey() == SECRET_CODE[nextLetter]) {
                if (++nextLetter >= SECRET_CODE.length) {
                    mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)PsiSoundHandler.book, (float)1.0f));
                    nextLetter = 0;
                    bookTime = 320;
                }
            } else {
                nextLetter = 0;
            }
        }
    }
}

