/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler.capability;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;

public class CADData
implements ICapabilityProvider,
ICADData,
ISpellAcceptor,
ISocketable,
IPsiBarDisplay {
    private final ItemStack cad;
    private int time;
    private int battery;
    private List<Vector3> vectors = Lists.newArrayList();
    private boolean dirty;
    private final LazyOptional<?> optional;

    public CADData(ItemStack cad) {
        this.cad = cad;
        this.optional = LazyOptional.of(() -> this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == PsiAPI.SOCKETABLE_CAPABILITY || capability == PsiAPI.CAD_DATA_CAPABILITY || capability == PsiAPI.PSI_BAR_DISPLAY_CAPABILITY || capability == PsiAPI.SPELL_ACCEPTOR_CAPABILITY) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int time) {
        if (this.time != time) {
            this.time = time;
        }
    }

    @Override
    public int getBattery() {
        return this.battery;
    }

    @Override
    public void setBattery(int battery) {
        this.battery = battery;
    }

    @Override
    public Vector3 getSavedVector(int memorySlot) {
        if (this.vectors.size() <= memorySlot) {
            return Vector3.zero.copy();
        }
        Vector3 vec = this.vectors.get(memorySlot);
        return (vec == null ? Vector3.zero : vec).copy();
    }

    @Override
    public void setSavedVector(int memorySlot, Vector3 value) {
        while (this.vectors.size() <= memorySlot) {
            this.vectors.add(null);
        }
        this.vectors.set(memorySlot, value);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public void setSpell(PlayerEntity player, Spell spell) {
        int slot = this.getSelectedSlot();
        ItemStack bullet = this.getBulletInSocket(slot);
        if (!bullet.func_190926_b() && ISpellAcceptor.isAcceptor(bullet)) {
            ISpellAcceptor.acceptor(bullet).setSpell(player, spell);
            this.setBulletInSocket(slot, bullet);
            player.func_184811_cZ().func_185145_a(this.cad.func_77973_b(), 10);
        }
    }

    @Override
    public boolean requiresSneakForSpellSet() {
        return true;
    }

    @Override
    public boolean isSocketSlotAvailable(int slot) {
        int sockets = ((ICAD)this.cad.func_77973_b()).getStatValue(this.cad, EnumCADStat.SOCKETS);
        if (sockets == -1 || sockets > 12) {
            sockets = 12;
        }
        return slot < sockets;
    }

    @Override
    public ItemStack getBulletInSocket(int slot) {
        String name = "bullet" + slot;
        CompoundNBT cmp = this.cad.func_196082_o().func_74775_l(name);
        if (cmp.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)cmp);
    }

    @Override
    public void setBulletInSocket(int slot, ItemStack bullet) {
        String name = "bullet" + slot;
        CompoundNBT cmp = new CompoundNBT();
        if (!bullet.func_190926_b()) {
            bullet.func_77955_b(cmp);
        }
        this.cad.func_196082_o().func_218657_a(name, (INBT)cmp);
    }

    @Override
    public int getSelectedSlot() {
        return this.cad.func_196082_o().func_74762_e("selectedSlot");
    }

    @Override
    public void setSelectedSlot(int slot) {
        this.cad.func_196082_o().func_74768_a("selectedSlot", slot);
    }

    @Override
    public CompoundNBT serializeForSynchronization() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("Time", this.time);
        compound.func_74768_a("Battery", this.battery);
        return compound;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = this.serializeForSynchronization();
        ListNBT memory = new ListNBT();
        for (Vector3 vector : this.vectors) {
            if (vector == null) {
                memory.add((Object)new ListNBT());
                continue;
            }
            ListNBT vec = new ListNBT();
            vec.add((Object)DoubleNBT.func_229684_a_((double)vector.x));
            vec.add((Object)DoubleNBT.func_229684_a_((double)vector.y));
            vec.add((Object)DoubleNBT.func_229684_a_((double)vector.z));
            memory.add((Object)vec);
        }
        compound.func_218657_a("Memory", (INBT)memory);
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_150297_b("Time", 99)) {
            this.time = nbt.func_74762_e("Time");
        }
        if (nbt.func_150297_b("Battery", 99)) {
            this.battery = nbt.func_74762_e("Battery");
        }
        if (nbt.func_150297_b("Memory", 9)) {
            ListNBT memory = nbt.func_150295_c("Memory", 9);
            ArrayList newVectors = Lists.newArrayList();
            for (int i = 0; i < memory.size(); ++i) {
                ListNBT vec = (ListNBT)memory.get(i);
                if (vec.func_230528_d__() == 6 && vec.size() >= 3) {
                    newVectors.add(new Vector3(vec.func_150309_d(0), vec.func_150309_d(1), vec.func_150309_d(2)));
                    continue;
                }
                newVectors.add(null);
            }
            this.vectors = newVectors;
        }
    }

    @Override
    public boolean shouldShow(IPlayerData data) {
        return true;
    }
}

