/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.CADStatEvent;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADAssembly;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ICADData;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.recipe.ITrickRecipe;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.PieceGroupAdvancementComplete;
import vazkii.psi.api.spell.PreSpellCastEvent;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCastEvent;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.BlockProgrammer;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.ContributorSpellCircleHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.core.handler.capability.CADData;
import vazkii.psi.common.crafting.ModCraftingRecipes;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.lib.LibPieceGroups;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageCADDataSync;
import vazkii.psi.common.network.message.MessageVisualEffect;
import vazkii.psi.common.spell.trick.block.PieceTrickBreakBlock;

public class ItemCAD
extends Item
implements ICAD {
    private static final String TAG_TIME_LEGACY = "time";
    private static final String TAG_STORED_PSI_LEGACY = "storedPsi";
    private static final String TAG_X_LEGACY = "x";
    private static final String TAG_Y_LEGACY = "y";
    private static final String TAG_Z_LEGACY = "z";
    private static final Pattern VECTOR_PREFIX_PATTERN = Pattern.compile("^storedVector(\\d+)$");
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*])|(?:ComputerCraft)$");

    public ItemCAD(Item.Properties properties) {
        super(properties.func_200917_a(1).addToolType(ToolType.PICKAXE, 0).addToolType(ToolType.AXE, 0).addToolType(ToolType.SHOVEL, 0));
    }

    private ICADData getCADData(ItemStack stack) {
        return (ICADData)stack.getCapability(PsiAPI.CAD_DATA_CAPABILITY).orElseGet(() -> new CADData(stack));
    }

    private ISocketable getSocketable(ItemStack stack) {
        return (ISocketable)stack.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElseGet(() -> new CADData(stack));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        CADData data = new CADData(stack);
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            data.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return data;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundNBT compound = stack.func_196082_o();
        stack.getCapability(PsiAPI.CAD_DATA_CAPABILITY).ifPresent(data -> {
            if (compound.func_150297_b(TAG_TIME_LEGACY, 99)) {
                data.setTime(compound.func_74762_e(TAG_TIME_LEGACY));
                data.markDirty(true);
                compound.func_82580_o(TAG_TIME_LEGACY);
            }
            if (compound.func_150297_b(TAG_STORED_PSI_LEGACY, 99)) {
                data.setBattery(compound.func_74762_e(TAG_STORED_PSI_LEGACY));
                data.markDirty(true);
                compound.func_82580_o(TAG_STORED_PSI_LEGACY);
            }
            HashSet keys = new HashSet(compound.func_150296_c());
            for (String key : keys) {
                Matcher matcher = VECTOR_PREFIX_PATTERN.matcher(key);
                if (!matcher.find()) continue;
                CompoundNBT vec = compound.func_74775_l(key);
                compound.func_82580_o(key);
                int memory = Integer.parseInt(matcher.group(1));
                Vector3 vector = new Vector3(vec.func_74769_h(TAG_X_LEGACY), vec.func_74769_h(TAG_Y_LEGACY), vec.func_74769_h(TAG_Z_LEGACY));
                data.setSavedVector(memory, vector);
            }
            if (entityIn instanceof ServerPlayerEntity && data.isDirty()) {
                ServerPlayerEntity player = (ServerPlayerEntity)entityIn;
                MessageRegister.sendToPlayer(new MessageCADDataSync((ICADData)data), (PlayerEntity)player);
                data.markDirty(false);
            }
        });
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World worldIn = ctx.func_195991_k();
        Hand hand = ctx.func_221531_n();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity playerIn = ctx.func_195999_j();
        ItemStack stack = playerIn.func_184586_b(hand);
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block == ModBlocks.programmer ? ((BlockProgrammer)block).setSpell(worldIn, pos, playerIn, stack) : ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack dyeStack;
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(playerIn);
        ItemStack playerCad = PsiAPI.getPlayerCAD(playerIn);
        if (playerCad != itemStackIn) {
            if (!worldIn.field_72995_K) {
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("psimisc.multiple_cads").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), Util.field_240973_b_);
            }
            return new ActionResult(ActionResultType.CONSUME, (Object)itemStackIn);
        }
        ISocketable sockets = this.getSocketable(playerCad);
        ItemStack bullet = sockets.getSelectedBullet();
        if (!this.getComponentInSlot(playerCad, EnumCADComponent.DYE).func_190926_b() && ContributorSpellCircleHandler.isContributor(playerIn.func_200200_C_().getString().toLowerCase()) && !((ICADColorizer)(dyeStack = this.getComponentInSlot(playerCad, EnumCADComponent.DYE)).func_77973_b()).getContributorName(dyeStack).equals(playerIn.func_200200_C_().getString().toLowerCase())) {
            ((ICADColorizer)dyeStack.func_77973_b()).setContributorName(dyeStack, playerIn.func_200200_C_().getString());
            this.setCADComponent(playerCad, dyeStack);
        }
        boolean did = ItemCAD.cast(worldIn, playerIn, data, bullet, itemStackIn, 40, 25, 0.5f, ctx -> {
            ctx.castFrom = hand;
        });
        if (!data.overflowed && bullet.func_190926_b() && this.craft(playerCad, playerIn, null)) {
            worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), PsiSoundHandler.cadShoot, SoundCategory.PLAYERS, 0.5f, (float)(0.5 + Math.random() * 0.5));
            data.deductPsi(100, 60, true);
            if (!data.hasAdvancement(LibPieceGroups.FAKE_LEVEL_PSIDUST)) {
                MinecraftForge.EVENT_BUS.post((Event)new PieceGroupAdvancementComplete(null, playerIn, LibPieceGroups.FAKE_LEVEL_PSIDUST));
            }
            did = true;
        }
        return new ActionResult(did ? ActionResultType.CONSUME : ActionResultType.PASS, (Object)itemStackIn);
    }

    public static boolean cast(World world, PlayerEntity player, PlayerDataHandler.PlayerData data, ItemStack bullet, ItemStack cad, int cd, int particles, float sound, Consumer<SpellContext> predicate) {
        return ItemCAD.cast(world, player, data, bullet, cad, cd, particles, sound, predicate, 0);
    }

    public static boolean cast(World world, PlayerEntity player, PlayerDataHandler.PlayerData data, ItemStack bullet, ItemStack cad, int cd, int particles, float sound, Consumer<SpellContext> predicate, int reservoir) {
        if (!data.overflowed && data.getAvailablePsi() > 0 && !cad.func_190926_b() && !bullet.func_190926_b() && ISpellAcceptor.hasSpell(bullet) && ItemCAD.isTruePlayer((Entity)player)) {
            ISpellAcceptor spellContainer = ISpellAcceptor.acceptor(bullet);
            Spell spell = spellContainer.getSpell();
            SpellContext context = new SpellContext().setPlayer(player).setSpell(spell);
            if (predicate != null) {
                predicate.accept(context);
            }
            if (context.isValid()) {
                if (context.cspell.metadata.evaluateAgainst(cad)) {
                    int cost = Math.max(ItemCAD.getRealCost(cad, bullet, context.cspell.metadata.stats.get((Object)EnumSpellStat.COST)) - reservoir, 0);
                    PreSpellCastEvent event = new PreSpellCastEvent(cost, sound, particles, cd, spell, context, player, data, cad, bullet);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        String cancelMessage = event.getCancellationMessage();
                        if (cancelMessage != null && !cancelMessage.isEmpty()) {
                            player.func_145747_a((ITextComponent)new TranslationTextComponent(cancelMessage).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), Util.field_240973_b_);
                        }
                        return false;
                    }
                    cd = event.getCooldown();
                    particles = event.getParticles();
                    sound = event.getSound();
                    cost = event.getCost();
                    spell = event.getSpell();
                    context = event.getContext();
                    if (cost > 0) {
                        data.deductPsi(cost, cd, true);
                    }
                    if (cost != 0 && sound > 0.0f) {
                        if (!world.field_72995_K) {
                            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), PsiSoundHandler.cadShoot, SoundCategory.PLAYERS, sound, (float)(0.5 + Math.random() * 0.5));
                        } else {
                            int color = Psi.proxy.getColorForCAD(cad);
                            float r = (float)PsiRenderHelper.r(color) / 255.0f;
                            float g = (float)PsiRenderHelper.g(color) / 255.0f;
                            float b = (float)PsiRenderHelper.b(color) / 255.0f;
                            for (int i = 0; i < particles; ++i) {
                                double x = player.func_226277_ct_() + (Math.random() - 0.5) * 2.1 * (double)player.func_213311_cf();
                                double y = player.func_226278_cu_() - player.func_70033_W();
                                double z = player.func_226281_cx_() + (Math.random() - 0.5) * 2.1 * (double)player.func_213311_cf();
                                float grav = -0.15f - (float)Math.random() * 0.03f;
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, grav, 0.25f, 15);
                            }
                            double x = player.func_226277_ct_();
                            double y = player.func_226278_cu_() + (double)player.func_70047_e() - 0.1;
                            double z = player.func_226281_cx_();
                            Vector3 lookOrig = new Vector3(player.func_70040_Z());
                            for (int i = 0; i < 25; ++i) {
                                Vector3 look = lookOrig.copy();
                                double spread = 0.25;
                                look.x += (Math.random() - 0.5) * spread;
                                look.y += (Math.random() - 0.5) * spread;
                                look.z += (Math.random() - 0.5) * spread;
                                look.normalize().multiply(0.15);
                                Psi.proxy.sparkleFX(x, y, z, r, g, b, (float)look.x, (float)look.y, (float)look.z, 0.3f, 5);
                            }
                        }
                    }
                    if (!world.field_72995_K) {
                        spellContainer.castSpell(context);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent(spell, context, player, data, cad, bullet));
                    return true;
                }
                if (!world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("psimisc.weak_cad").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.RED)), Util.field_240973_b_);
                }
            }
        }
        return false;
    }

    @Override
    public boolean craft(ItemStack cad, PlayerEntity player, PieceCraftingTrick craftingTrick) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return false;
        }
        List items = player.func_130014_f_().func_175647_a(ItemEntity.class, player.func_174813_aQ().func_186662_g(8.0), entity -> entity != null && entity.func_70068_e((Entity)player) <= 64.0);
        CraftingWrapper inv = new CraftingWrapper();
        boolean did = false;
        for (ItemEntity item : items) {
            int count;
            int dropCount;
            Optional<ITrickRecipe> recipe;
            ItemStack stack = item.func_92059_d();
            inv.setStack(stack);
            Predicate<ITrickRecipe> predicate = r -> r.getPiece() == null;
            if (craftingTrick != null) {
                predicate = r -> r.getPiece() == null || r.getPiece().canCraft(craftingTrick);
            }
            if (!(recipe = world.func_199532_z().func_215371_a(ModCraftingRecipes.TRICK_RECIPE_TYPE, (IInventory)inv, world).filter(predicate)).isPresent()) continue;
            ItemStack outCopy = recipe.get().func_77571_b().func_77946_l();
            for (count = stack.func_190916_E() * outCopy.func_190916_E(); count > 64; count -= dropCount) {
                dropCount = world.func_201674_k().nextInt(32) + 32;
                ItemEntity drop = new ItemEntity(world, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), new ItemStack((IItemProvider)outCopy.func_77973_b(), dropCount));
                Vector3d motion = item.func_213322_ci();
                drop.func_213293_j(motion.func_82615_a() + ((double)world.func_201674_k().nextFloat() - 0.5) / 5.0, motion.func_82617_b() + (double)(world.func_201674_k().nextFloat() / 10.0f), motion.func_82616_c() + ((double)world.func_201674_k().nextFloat() - 0.5) / 5.0);
                world.func_217376_c((Entity)drop);
            }
            outCopy.func_190920_e(count);
            item.func_92058_a(outCopy);
            did = true;
            MessageVisualEffect msg = new MessageVisualEffect(1295871, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), item.func_213311_cf(), item.func_213302_cg(), item.func_70033_W(), 0);
            MessageRegister.HANDLER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> item), (Object)msg);
        }
        return did;
    }

    public static int getRealCost(ItemStack stack, ItemStack bullet, int cost) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ICAD) {
            int eff = ((ICAD)stack.func_77973_b()).getStatValue(stack, EnumCADStat.EFFICIENCY);
            if (eff == -1) {
                return -1;
            }
            if (eff == 0) {
                return cost;
            }
            double effPercentile = (double)eff / 100.0;
            double procCost = (double)cost / effPercentile;
            if (!bullet.func_190926_b() && ISpellAcceptor.isContainer(bullet)) {
                procCost *= ISpellAcceptor.acceptor(bullet).getCostModifier();
            }
            return (int)procCost;
        }
        return cost;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)e;
        String name = player.func_200200_C_().getString();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    public static void setComponent(ItemStack stack, ItemStack componentStack) {
        if (stack.func_77973_b() instanceof ICAD) {
            ((ICAD)stack.func_77973_b()).setCADComponent(stack, componentStack);
        }
    }

    public static ItemStack makeCAD(ItemStack ... components) {
        return ItemCAD.makeCAD(Arrays.asList(components));
    }

    public static ItemStack makeCADWithAssembly(ItemStack assembly, List<ItemStack> components) {
        ItemStack cad = assembly.func_77973_b() instanceof ICADAssembly ? ((ICADAssembly)assembly.func_77973_b()).createCADStack(assembly, components) : new ItemStack((IItemProvider)ModItems.cad);
        return ItemCAD.makeCAD(cad, components);
    }

    public static ItemStack makeCAD(List<ItemStack> components) {
        return ItemCAD.makeCAD(new ItemStack((IItemProvider)ModItems.cad), components);
    }

    public static ItemStack makeCAD(ItemStack base, List<ItemStack> components) {
        ItemStack stack = base.func_77946_l();
        for (ItemStack component : components) {
            ItemCAD.setComponent(stack, component);
        }
        return stack;
    }

    @Override
    public ItemStack getComponentInSlot(ItemStack stack, EnumCADComponent type) {
        String name = "component" + type.name();
        CompoundNBT cmp = stack.func_196082_o().func_74775_l(name);
        if (cmp.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)cmp);
    }

    @Override
    public int getStatValue(ItemStack stack, EnumCADStat stat) {
        int statValue = 0;
        ItemStack componentStack = this.getComponentInSlot(stack, stat.getSourceType());
        if (!componentStack.func_190926_b() && componentStack.func_77973_b() instanceof ICADComponent) {
            ICADComponent component = (ICADComponent)componentStack.func_77973_b();
            statValue = component.getCADStatValue(componentStack, stat);
        }
        CADStatEvent event = new CADStatEvent(stat, stack, componentStack, statValue);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getStatValue();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getSpellColor(ItemStack stack) {
        ItemStack dye = this.getComponentInSlot(stack, EnumCADComponent.DYE);
        if (!dye.func_190926_b() && dye.func_77973_b() instanceof ICADColorizer) {
            return ((ICADColorizer)dye.func_77973_b()).getColor(dye);
        }
        return 1295871;
    }

    @Override
    public int getTime(ItemStack stack) {
        return this.getCADData(stack).getTime();
    }

    @Override
    public void incrementTime(ItemStack stack) {
        ICADData data = this.getCADData(stack);
        data.setTime(data.getTime() + 1);
    }

    @Override
    public int getStoredPsi(ItemStack stack) {
        int maxPsi = this.getStatValue(stack, EnumCADStat.OVERFLOW);
        return Math.min(this.getCADData(stack).getBattery(), maxPsi);
    }

    @Override
    public void regenPsi(ItemStack stack, int psi) {
        int maxPsi = this.getStatValue(stack, EnumCADStat.OVERFLOW);
        if (maxPsi == -1) {
            return;
        }
        int currPsi = this.getStoredPsi(stack);
        int endPsi = Math.min(currPsi + psi, maxPsi);
        if (endPsi != currPsi) {
            ICADData data = this.getCADData(stack);
            data.setBattery(endPsi);
            data.markDirty(true);
        }
    }

    @Override
    public int consumePsi(ItemStack stack, int psi) {
        if (psi == 0) {
            return 0;
        }
        int currPsi = this.getStoredPsi(stack);
        if (currPsi == -1) {
            return 0;
        }
        ICADData data = this.getCADData(stack);
        if (currPsi >= psi) {
            data.setBattery(currPsi - psi);
            data.markDirty(true);
            return 0;
        }
        data.setBattery(0);
        data.markDirty(true);
        return psi - currPsi;
    }

    @Override
    public int getMemorySize(ItemStack stack) {
        int vectors = this.getStatValue(stack, EnumCADStat.SAVED_VECTORS);
        if (vectors == -1) {
            return 255;
        }
        return vectors;
    }

    @Override
    public void setStoredVector(ItemStack stack, int memorySlot, Vector3 vec) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds");
        }
        this.getCADData(stack).setSavedVector(memorySlot, vec);
    }

    @Override
    public Vector3 getStoredVector(ItemStack stack, int memorySlot) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds");
        }
        return this.getCADData(stack).getSavedVector(memorySlot);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (!PieceTrickBreakBlock.doingHarvestCheck.get().booleanValue()) {
            return -1;
        }
        int level = super.getHarvestLevel(stack, tool, player, blockState);
        return level < 0 ? -1 : Math.max(level, (Integer)ConfigHandler.COMMON.cadHarvestLevel.get());
    }

    @Nonnull
    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (!PieceTrickBreakBlock.doingHarvestCheck.get().booleanValue()) {
            return Collections.emptySet();
        }
        return super.getToolTypes(stack);
    }

    public boolean canHarvestBlock(ItemStack stack, @Nonnull BlockState state) {
        int level;
        if (!PieceTrickBreakBlock.doingHarvestCheck.get().booleanValue()) {
            return super.canHarvestBlock(stack, state);
        }
        Block block = state.func_177230_c();
        ToolType tool = block.getHarvestTool(state);
        int n = level = tool == null ? -1 : this.getHarvestLevel(stack, tool, null, state);
        if (level >= 0) {
            return level >= block.getHarvestLevel(state);
        }
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((IItemProvider)ModItems.cadAssemblyIron)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((IItemProvider)ModItems.cadAssemblyIron), new ItemStack((IItemProvider)ModItems.cadCoreBasic), new ItemStack((IItemProvider)ModItems.cadSocketBasic), new ItemStack((IItemProvider)ModItems.cadBatteryBasic)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((IItemProvider)ModItems.cadAssemblyGold), new ItemStack((IItemProvider)ModItems.cadCoreBasic), new ItemStack((IItemProvider)ModItems.cadSocketBasic), new ItemStack((IItemProvider)ModItems.cadBatteryBasic)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((IItemProvider)ModItems.cadAssemblyPsimetal), new ItemStack((IItemProvider)ModItems.cadCoreOverclocked), new ItemStack((IItemProvider)ModItems.cadSocketSignaling), new ItemStack((IItemProvider)ModItems.cadBatteryExtended)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((IItemProvider)ModItems.cadAssemblyEbony), new ItemStack((IItemProvider)ModItems.cadCoreHyperClocked), new ItemStack((IItemProvider)ModItems.cadSocketTransmissive), new ItemStack((IItemProvider)ModItems.cadBatteryUltradense)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((IItemProvider)ModItems.cadAssemblyIvory), new ItemStack((IItemProvider)ModItems.cadCoreHyperClocked), new ItemStack((IItemProvider)ModItems.cadSocketTransmissive), new ItemStack((IItemProvider)ModItems.cadBatteryUltradense)));
        subItems.add((Object)ItemCAD.makeCAD(new ItemStack((IItemProvider)ModItems.cadAssemblyCreative), new ItemStack((IItemProvider)ModItems.cadCoreHyperClocked), new ItemStack((IItemProvider)ModItems.cadSocketTransmissive), new ItemStack((IItemProvider)ModItems.cadBatteryUltradense)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerin, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            ITextComponent componentName = ISocketable.getSocketedItemName(stack, "psimisc.none");
            tooltip.add((ITextComponent)new TranslationTextComponent("psimisc.spell_selected", new Object[]{componentName}));
            for (EnumCADComponent componentType : (EnumCADComponent[])EnumCADComponent.class.getEnumConstants()) {
                ItemStack componentStack = this.getComponentInSlot(stack, componentType);
                TranslationTextComponent name = new TranslationTextComponent("psimisc.none");
                if (!componentStack.func_190926_b()) {
                    name = componentStack.func_200301_q();
                }
                IFormattableTextComponent componentTypeName = new TranslationTextComponent(componentType.getName()).func_240699_a_(TextFormatting.GREEN);
                tooltip.add((ITextComponent)componentTypeName.func_240702_b_(": ").func_230529_a_((ITextComponent)name));
                for (EnumCADStat stat : (EnumCADStat[])EnumCADStat.class.getEnumConstants()) {
                    if (stat.getSourceType() != componentType) continue;
                    String shrt = stat.getName();
                    int statVal = this.getStatValue(stack, stat);
                    String statValStr = statVal == -1 ? "\u221e" : "" + statVal;
                    tooltip.add((ITextComponent)new TranslationTextComponent(shrt).func_240699_a_(TextFormatting.AQUA).func_240702_b_(": " + statValStr));
                }
            }
        });
    }

    @Nonnull
    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.RARE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77969_a(newStack);
    }

    private static class CraftingWrapper
    extends RecipeWrapper {
        CraftingWrapper() {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
        }

        void setStack(ItemStack stack) {
            this.inv.setStackInSlot(0, stack);
        }
    }
}

