/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.component;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.internal.TooltipHelper;
import vazkii.psi.common.Psi;

public abstract class ItemCADComponent
extends Item
implements ICADComponent {
    private final HashMap<EnumCADStat, Integer> stats = new HashMap();

    public ItemCADComponent(Item.Properties properties) {
        super(properties.func_200917_a(1));
        this.registerStats();
    }

    public void registerStats() {
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        TooltipHelper.tooltipIfShift(tooltip, () -> {
            EnumCADComponent componentType = this.getComponentType(stack);
            TranslationTextComponent componentName = new TranslationTextComponent(componentType.getName());
            tooltip.add((ITextComponent)new TranslationTextComponent("psimisc.component_type", new Object[]{componentName}));
            for (EnumCADStat stat : (EnumCADStat[])EnumCADStat.class.getEnumConstants()) {
                if (stat.getSourceType() != componentType) continue;
                int statVal = this.getCADStatValue(stack, stat);
                String statValStr = statVal == -1 ? "\u221e" : "" + statVal;
                IFormattableTextComponent name = new TranslationTextComponent(stat.getName()).func_240699_a_(TextFormatting.AQUA);
                tooltip.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)name).func_240702_b_(": " + statValStr));
            }
        });
    }

    public void addStat(HashMap<EnumCADStat, Integer> stats) {
        stats.forEach(this::addStat);
    }

    public void addStat(EnumCADStat stat, int value) {
        this.stats.put(stat, value);
    }

    public static void addStatToStack(ItemStack stack, EnumCADStat stat, int value) {
        if (stack.func_77973_b() instanceof ItemCADComponent) {
            ((ItemCADComponent)stack.func_77973_b()).addStat(stat, value);
        } else {
            Psi.logger.error("Tried to add stats to non-component Item: " + stack.func_77973_b().func_200296_o());
        }
    }

    public static void addStatToStack(Item item, EnumCADStat stat, int value) {
        if (item instanceof ItemCADComponent) {
            ((ItemCADComponent)item).addStat(stat, value);
        } else {
            Psi.logger.error("Tried to add stats to non-component Item: " + item.func_200296_o());
        }
    }

    @Override
    public int getCADStatValue(ItemStack stack, EnumCADStat stat) {
        if (this.stats.containsKey((Object)stat)) {
            return this.stats.get((Object)stat);
        }
        return 0;
    }
}

