/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell;

import com.mojang.datafixers.util.Either;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import vazkii.psi.api.spell.CompiledSpell;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.IErrorCatcher;
import vazkii.psi.api.spell.ISpellCompiler;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;

public final class SpellCompiler
implements ISpellCompiler {
    private CompiledSpell compiled;
    private final Set<SpellPiece> processedHandlers = new HashSet<SpellPiece>();
    private final Set<SpellPiece> redirectionPieces = new HashSet<SpellPiece>();

    @Override
    public Either<CompiledSpell, SpellCompilationException> compile(Spell in) {
        try {
            return Either.left((Object)this.doCompile(in));
        }
        catch (SpellCompilationException e) {
            return Either.right((Object)e);
        }
    }

    public CompiledSpell doCompile(Spell spell) throws SpellCompilationException {
        if (spell == null) {
            throw new SpellCompilationException("psi.spellerror.nospell");
        }
        this.processedHandlers.clear();
        this.redirectionPieces.clear();
        this.compiled = new CompiledSpell(spell);
        List<SpellPiece> tricks = this.findPieces(EnumPieceType::isTrick);
        if (tricks.isEmpty()) {
            throw new SpellCompilationException("psi.spellerror.notricks");
        }
        for (SpellPiece trick : tricks) {
            this.buildPiece(trick);
        }
        for (SpellPiece piece : this.findPieces(EnumPieceType.ERROR_HANDLER::equals)) {
            if (!this.processedHandlers.add(piece)) continue;
            this.buildPiece(piece);
        }
        if (this.compiled.metadata.stats.get((Object)EnumSpellStat.COST) < 0 || this.compiled.metadata.stats.get((Object)EnumSpellStat.POTENCY) < 0) {
            throw new SpellCompilationException("psi.spellerror.statoverflow");
        }
        if (spell.name == null || spell.name.isEmpty()) {
            throw new SpellCompilationException("psi.spellerror.noname");
        }
        return this.compiled;
    }

    public void buildPiece(SpellPiece piece) throws SpellCompilationException {
        this.buildPiece(piece, new HashSet<SpellPiece>());
    }

    public void buildPiece(SpellPiece piece, Set<SpellPiece> visited) throws SpellCompilationException {
        CompiledSpell.CatchHandler catchHandler;
        CompiledSpell.Action a;
        if (!visited.add(piece)) {
            throw new SpellCompilationException("psi.spellerror.loop", piece.x, piece.y);
        }
        if (this.compiled.actionMap.containsKey(piece)) {
            a = this.compiled.actionMap.get(piece);
            this.compiled.actions.remove(a);
            this.compiled.actions.add(a);
        } else {
            CompiledSpell compiledSpell = this.compiled;
            compiledSpell.getClass();
            a = compiledSpell.new CompiledSpell.Action(piece);
            this.compiled.actions.add(a);
            this.compiled.actionMap.put(piece, a);
            piece.addToMetadata(this.compiled.metadata);
        }
        CompiledSpell.CatchHandler errorHandler = null;
        if (piece instanceof IErrorCatcher) {
            CompiledSpell compiledSpell = this.compiled;
            compiledSpell.getClass();
            errorHandler = compiledSpell.new CompiledSpell.CatchHandler(piece);
            this.processedHandlers.add(piece);
        }
        if ((catchHandler = this.compiled.errorHandlers.get(piece)) != null) {
            this.buildPiece(catchHandler.handlerPiece, new HashSet<SpellPiece>(visited));
        }
        EnumSet<SpellParam.Side> usedSides = EnumSet.noneOf(SpellParam.Side.class);
        HashSet<SpellPiece> params = new HashSet<SpellPiece>();
        HashSet<SpellPiece> handledErrors = new HashSet<SpellPiece>();
        for (SpellParam<?> param : piece.paramSides.keySet()) {
            if (this.checkSideDisabled(param, piece, usedSides)) continue;
            SpellParam.Side side = piece.paramSides.get(param);
            SpellPiece pieceAt = this.compiled.sourceSpell.grid.getPieceAtSideWithRedirections(piece.x, piece.y, side, this::buildRedirect);
            if (pieceAt == null) {
                throw new SpellCompilationException("psi.spellerror.nullparam", piece.x, piece.y);
            }
            if (!param.canAccept(pieceAt)) {
                throw new SpellCompilationException("psi.spellerror.invalidparam", piece.x, piece.y);
            }
            if (errorHandler != null && ((IErrorCatcher)((Object)piece)).catchParam(param)) {
                this.compiled.errorHandlers.putIfAbsent(pieceAt, errorHandler);
                handledErrors.add(pieceAt);
                continue;
            }
            params.add(pieceAt);
        }
        for (SpellPiece pieceAt : params) {
            HashSet<SpellPiece> visitedCopy = new HashSet<SpellPiece>(visited);
            visitedCopy.addAll(handledErrors);
            this.buildPiece(pieceAt, visitedCopy);
        }
    }

    public void buildRedirect(SpellPiece piece) throws SpellCompilationException {
        if (this.redirectionPieces.add(piece)) {
            piece.addToMetadata(this.compiled.metadata);
            EnumSet<SpellParam.Side> usedSides = EnumSet.noneOf(SpellParam.Side.class);
            for (SpellParam<?> param : piece.paramSides.keySet()) {
                this.checkSideDisabled(param, piece, usedSides);
            }
        }
    }

    private boolean checkSideDisabled(SpellParam<?> param, SpellPiece parent, EnumSet<SpellParam.Side> seen) throws SpellCompilationException {
        SpellParam.Side side = parent.paramSides.get(param);
        if (side.isEnabled()) {
            if (!seen.add(side)) {
                throw new SpellCompilationException("psi.spellerror.samesideparams", parent.x, parent.y);
            }
            return false;
        }
        if (!param.canDisable) {
            throw new SpellCompilationException("psi.spellerror.unsetparam", parent.x, parent.y);
        }
        return true;
    }

    public List<SpellPiece> findPieces(Predicate<EnumPieceType> match) throws SpellCompilationException {
        LinkedList<SpellPiece> results = new LinkedList<SpellPiece>();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = this.compiled.sourceSpell.grid.gridData[j][i];
                if (piece == null || !match.test(piece.getPieceType())) continue;
                results.add(0, piece);
            }
        }
        return results;
    }
}

