/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import net.minecraft.entity.player.ServerPlayerEntity;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageEidosSync;

public class PieceTrickEidosReversal
extends PieceTrick {
    SpellParam<Number> time;

    public PieceTrickEidosReversal(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.RED, false, true);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double timeVal = (Double)this.getParamEvaluation(this.time);
        if (timeVal == null || timeVal <= 0.0 || timeVal != (double)timeVal.intValue()) {
            throw new SpellCompilationException("psi.spellerror.nonpositiveinteger", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(timeVal * 11.0 + 20.0));
        meta.addStat(EnumSpellStat.COST, timeVal.intValue() * 40);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        int timeVal = this.getParamValue(context, this.time).intValue();
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(context.caster);
        if (!data.isReverting) {
            data.eidosReversionTime = timeVal * 10;
            data.isReverting = true;
            if (context.caster instanceof ServerPlayerEntity) {
                MessageRegister.sendToPlayer(new MessageEidosSync(data.eidosReversionTime), context.caster);
            }
        }
        return null;
    }
}

