/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.client.core.handler.HUDHandler;
import vazkii.psi.common.block.base.DirectionBlockItemUseContext;
import vazkii.psi.common.block.base.ModBlocks;

public class PieceTrickPlaceBlock
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Vector3> direction;

    public PieceTrickPlaceBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.direction = new ParamVector("psi.spellparam.direction", SpellParam.GREEN, true, false);
        this.addParam(this.direction);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 8);
        meta.addStat(EnumSpellStat.COST, 8);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        Vector3 directionVal = this.getParamValue(context, this.direction);
        Direction facing = Direction.NORTH;
        Direction horizontalFacing = Direction.NORTH;
        if (directionVal != null) {
            facing = Direction.func_210769_a((double)directionVal.x, (double)directionVal.y, (double)directionVal.z);
            horizontalFacing = Direction.func_210769_a((double)directionVal.x, (double)0.0, (double)directionVal.z);
        }
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        PieceTrickPlaceBlock.placeBlock(context.caster, context.caster.func_130014_f_(), pos, context.getTargetSlot(), false, facing, horizontalFacing);
        return null;
    }

    public static void placeBlock(PlayerEntity player, World world, BlockPos pos, int slot, boolean particles, Direction direction, Direction horizontalDirection) {
        PieceTrickPlaceBlock.placeBlock(player, world, pos, slot, particles, false, direction, horizontalDirection);
    }

    public static void placeBlock(PlayerEntity player, World world, BlockPos pos, int slot, boolean particles, boolean conjure, Direction direction, Direction horizontalDirection) {
        if (!world.func_175667_e(pos) || !world.func_175660_a(player, pos)) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos), world.func_180495_p(pos.func_177972_a(Direction.UP)), (Entity)player);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (state.isAir((IBlockReader)world, pos) || state.func_185904_a().func_76222_j() && !placeEvent.isCanceled()) {
            if (conjure) {
                world.func_175656_a(pos, ModBlocks.conjured.func_176223_P());
            } else {
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem) {
                    ItemStack rem = PieceTrickPlaceBlock.removeFromInventory(player, stack, true);
                    BlockItem iblock = (BlockItem)rem.func_77973_b();
                    BlockRayTraceResult hit = new BlockRayTraceResult(Vector3d.field_186680_a, direction, pos, false);
                    ItemUseContext ctx = new ItemUseContext(player, Hand.MAIN_HAND, hit);
                    ItemStack save = player.func_184586_b(ctx.func_221531_n());
                    player.func_184611_a(ctx.func_221531_n(), rem);
                    ItemUseContext newCtx = new ItemUseContext(ctx.func_195999_j(), ctx.func_221531_n(), hit);
                    player.func_184611_a(newCtx.func_221531_n(), save);
                    ActionResultType result = iblock.func_195942_a((BlockItemUseContext)new DirectionBlockItemUseContext(newCtx, horizontalDirection));
                    if (result != ActionResultType.FAIL) {
                        PieceTrickPlaceBlock.removeFromInventory(player, stack, false);
                        if (player.field_71075_bZ.field_75098_d) {
                            HUDHandler.setRemaining(rem, -1);
                        } else {
                            HUDHandler.setRemaining(player, rem, null);
                        }
                    }
                }
            }
            if (particles) {
                world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)world.func_180495_p(pos)));
            }
        }
    }

    public static ItemStack removeFromInventory(PlayerEntity player, ItemStack stack, boolean copy) {
        if (player.field_71075_bZ.field_75098_d) {
            return stack.func_77946_l();
        }
        PlayerInventory inv = player.field_71071_by;
        for (int i = inv.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (invStack.func_190926_b() || !invStack.func_77969_a(stack) || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)invStack)) continue;
            ItemStack retStack = invStack.func_77946_l();
            if (!copy) {
                invStack.func_190918_g(1);
                if (invStack.func_190916_E() == 0) {
                    inv.func_70299_a(i, ItemStack.field_190927_a);
                }
            }
            return retStack;
        }
        return ItemStack.field_190927_a;
    }
}

