/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix.impl.melee;

import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import shadows.apotheosis.deadly.affix.EquipmentType;
import shadows.apotheosis.deadly.affix.impl.RangedAffix;
import shadows.apotheosis.deadly.affix.modifiers.AffixModifier;

public class LootPinataAffix
extends RangedAffix {
    public LootPinataAffix(int weight) {
        super(0.001f, 0.02f, weight);
    }

    @Override
    public boolean canApply(EquipmentType type) {
        return type == EquipmentType.SWORD;
    }

    @Override
    public float generateLevel(ItemStack stack, Random rand, @Nullable AffixModifier modifier) {
        float lvl = this.range.func_186507_b(rand);
        if (modifier != null) {
            lvl = modifier.editLevel(this, lvl);
        }
        return lvl;
    }

    @Override
    public void addInformation(ItemStack stack, float level, Consumer<ITextComponent> list) {
        list.accept((ITextComponent)LootPinataAffix.loreComponent("affix." + this.getRegistryName() + ".desc", LootPinataAffix.fmt(level * 100.0f)));
    }

    @Override
    public ITextComponent getDisplayName(float level) {
        return new TranslationTextComponent("affix." + this.getRegistryName() + ".name", new Object[]{LootPinataAffix.fmt(level * 100.0f)}).func_240699_a_(TextFormatting.GRAY);
    }

    @Override
    public float getMax() {
        return 0.03f;
    }
}

