/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.deadly.affix.impl.tool;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import shadows.apotheosis.deadly.affix.Affix;
import shadows.apotheosis.deadly.affix.AffixHelper;
import shadows.apotheosis.deadly.affix.Affixes;
import shadows.apotheosis.deadly.affix.EquipmentType;
import shadows.apotheosis.deadly.affix.modifiers.AffixModifier;
import shadows.placebo.util.PlaceboUtil;

public class RadiusMiningAffix
extends Affix {
    private static Set<UUID> breakers = new HashSet<UUID>();

    public RadiusMiningAffix(int weight) {
        super(weight);
    }

    @Override
    public float generateLevel(ItemStack stack, Random rand, @Nullable AffixModifier modifier) {
        int lvl = 1 + rand.nextInt(2);
        if (modifier != null) {
            lvl = (int)modifier.editLevel(this, lvl);
        }
        return lvl;
    }

    @Override
    public void addInformation(ItemStack stack, float level, Consumer<ITextComponent> list) {
        list.accept((ITextComponent)RadiusMiningAffix.loreComponent("affix." + this.getRegistryName() + ".desc" + (int)level, new Object[0]));
    }

    @Override
    public ITextComponent getDisplayName(float level) {
        return new TranslationTextComponent("affix." + this.getRegistryName() + ".name" + (int)level).func_240699_a_(TextFormatting.GRAY);
    }

    @Override
    public float getMin() {
        return 1.0f;
    }

    @Override
    public float getMax() {
        return 3.0f;
    }

    @Override
    public float upgradeLevel(float curLvl, float newLvl) {
        return (int)super.upgradeLevel(curLvl, newLvl);
    }

    @Override
    public float obliterateLevel(float level) {
        return (int)super.obliterateLevel(level);
    }

    @Override
    public boolean canApply(EquipmentType type) {
        return type == EquipmentType.PICKAXE || type == EquipmentType.SHOVEL;
    }

    public static void breakExtraBlocks(ServerPlayerEntity player, BlockPos pos, ItemStack tool, int level, float hardness) {
        if (!breakers.add(player.func_110124_au())) {
            return;
        }
        if (!player.func_225608_bj_()) {
            try {
                if (level == 1) {
                    RadiusMiningAffix.breakBlockRadius(player, pos, 1, 2, 0, 1, hardness);
                } else if (level == 2) {
                    RadiusMiningAffix.breakBlockRadius(player, pos, 3, 2, 0, 1, hardness);
                } else {
                    RadiusMiningAffix.breakBlockRadius(player, pos, 3, 3, 0, 0, hardness);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        breakers.remove(player.func_110124_au());
    }

    public static void breakBlockRadius(ServerPlayerEntity player, BlockPos pos, int x, int y, int xOff, int yOff, float hardness) {
        World world = player.field_70170_p;
        if (x < 2 && y < 2) {
            return;
        }
        int lowerY = (int)Math.ceil((double)(-y) / 2.0);
        int upperY = (int)Math.round((double)y / 2.0);
        int lowerX = (int)Math.ceil((double)(-x) / 2.0);
        int upperX = (int)Math.round((double)x / 2.0);
        Vector3d base = player.func_174824_e(0.0f);
        Vector3d look = player.func_70040_Z();
        double reach = player.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        Vector3d target = base.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        BlockRayTraceResult trace = world.func_217299_a(new RayTraceContext(base, target, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (trace == null || trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult res = trace;
        Direction face = res.func_216354_b();
        for (int iy = lowerY; iy < upperY; ++iy) {
            for (int ix = lowerX; ix < upperX; ++ix) {
                BlockPos genPos = new BlockPos(pos.func_177958_n() + ix + xOff, pos.func_177956_o() + iy + yOff, pos.func_177952_p());
                if (player.func_174811_aO().func_176740_k() == Direction.Axis.X) {
                    genPos = new BlockPos(genPos.func_177958_n() - (ix + xOff), genPos.func_177956_o(), genPos.func_177952_p() + ix + xOff);
                }
                if (face.func_176740_k().func_200128_b()) {
                    genPos = RadiusMiningAffix.rotateDown(genPos, iy + yOff, player.func_174811_aO());
                }
                if (genPos.equals((Object)pos)) continue;
                BlockState state = world.func_180495_p(genPos);
                float stateHardness = state.func_185887_b((IBlockReader)world, genPos);
                if (state.func_196958_f() || stateHardness == -1.0f || !(stateHardness <= hardness * 3.0f) || !RadiusMiningAffix.isEffective(state, (PlayerEntity)player)) continue;
                PlaceboUtil.tryHarvestBlock((ServerPlayerEntity)player, (BlockPos)genPos);
            }
        }
    }

    static BlockPos rotateDown(BlockPos pos, int y, Direction horizontal) {
        Vector3i vec = horizontal.func_176730_m();
        return new BlockPos(pos.func_177958_n() + vec.func_177958_n() * y, pos.func_177956_o() - y, pos.func_177952_p() + vec.func_177952_p() * y);
    }

    static boolean isEffective(BlockState state, PlayerEntity player) {
        if (player.func_184614_ca().getToolTypes().stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0))) {
            return true;
        }
        if (AffixHelper.getAffixLevel(player.func_184614_ca(), Affixes.OMNITOOL) > 0.0f) {
            return Items.field_151046_w.func_150897_b(state) || Items.field_151047_v.func_150897_b(state) || Items.field_151056_x.func_150897_b(state);
        }
        return false;
    }
}

