/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ApotheosisObjects;

public class PotionCharmRecipe
extends ShapedRecipe {
    protected final IntList potionSlots = new IntArrayList();

    public PotionCharmRecipe(List<Object> ingredients, int width, int height) {
        super(new ResourceLocation("apotheosis", "potion_charm"), "", width, height, PotionCharmRecipe.makeIngredients(ingredients), new ItemStack((IItemProvider)ApotheosisObjects.POTION_CHARM));
        for (int i = 0; i < ingredients.size(); ++i) {
            if (!ingredients.get(i).equals("potion")) continue;
            this.potionSlots.add(i);
        }
    }

    private static NonNullList<Ingredient> makeIngredients(List<Object> ingredients) {
        ArrayList<ItemStack> potionStacks = new ArrayList<ItemStack>();
        ArrayList<Object> realIngredients = new ArrayList<Object>();
        for (Potion p : ForgeRegistries.POTION_TYPES) {
            if (p.func_185170_a().size() != 1 || ((EffectInstance)p.func_185170_a().get(0)).func_188419_a().func_76403_b()) continue;
            ItemStack potion = new ItemStack((IItemProvider)Items.field_151068_bn);
            PotionUtils.func_185188_a((ItemStack)potion, (Potion)p);
            potionStacks.add(potion);
        }
        Ingredient potion = Ingredient.func_193369_a((ItemStack[])potionStacks.toArray(new ItemStack[0]));
        for (Object o : ingredients) {
            if (o.equals("potion")) {
                realIngredients.add(potion);
                continue;
            }
            realIngredients.add(o);
        }
        return Apotheosis.HELPER.createInput(true, realIngredients.toArray());
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack out = super.func_77572_b(inv);
        PotionUtils.func_185188_a((ItemStack)out, (Potion)PotionUtils.func_185191_c((ItemStack)inv.func_70301_a(4)));
        return out;
    }

    public boolean func_77569_a(CraftingInventory inv, World world) {
        List potions;
        if (super.func_77569_a(inv, world) && (potions = this.potionSlots.stream().map(s -> inv.func_70301_a(s.intValue())).map(PotionUtils::func_185191_c).collect(Collectors.toList())).size() > 0 && potions.stream().allMatch(p -> p != null && p.func_185170_a().size() == 1 && !((EffectInstance)p.func_185170_a().get(0)).func_188419_a().func_76403_b())) {
            return potions.stream().distinct().count() == 1L;
        }
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PotionCharmRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public PotionCharmRecipe read(ResourceLocation recipeId, JsonObject json) {
            JsonArray inputs = json.get("recipe").getAsJsonArray();
            int width = 0;
            int height = inputs.size();
            ArrayList<Object> ingredients = new ArrayList<Object>();
            for (JsonElement e : inputs) {
                JsonArray arr = e.getAsJsonArray();
                width = arr.size();
                for (JsonElement input : arr) {
                    if (input.isJsonPrimitive() && input.getAsString().equals("potion")) {
                        ingredients.add("potion");
                        continue;
                    }
                    ingredients.add(CraftingHelper.getIngredient((JsonElement)input));
                }
            }
            return new PotionCharmRecipe(ingredients, width, height);
        }

        public PotionCharmRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            byte width = buffer.readByte();
            byte height = buffer.readByte();
            int potions = buffer.readByte();
            IntArrayList potionSlots = new IntArrayList();
            for (int i = 0; i < potions; ++i) {
                potionSlots.add((int)buffer.readByte());
            }
            ArrayList<Object> inputs = new ArrayList<Object>(width * height);
            for (int i = 0; i < width * height; ++i) {
                if (!potionSlots.contains(i)) {
                    inputs.add(i, Ingredient.func_199566_b((PacketBuffer)buffer));
                    continue;
                }
                inputs.add("potion");
            }
            return new PotionCharmRecipe(inputs, width, height);
        }

        public void write(PacketBuffer buffer, PotionCharmRecipe recipe) {
            int i;
            buffer.writeByte(recipe.getRecipeWidth());
            buffer.writeByte(recipe.getRecipeHeight());
            buffer.writeByte(recipe.potionSlots.size());
            IntListIterator intListIterator = recipe.potionSlots.iterator();
            while (intListIterator.hasNext()) {
                i = (Integer)intListIterator.next();
                buffer.writeByte(i);
            }
            NonNullList inputs = recipe.func_192400_c();
            for (i = 0; i < inputs.size(); ++i) {
                if (recipe.potionSlots.contains(i)) continue;
                ((Ingredient)inputs.get(i)).func_199564_a(buffer);
            }
        }
    }
}

