/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;

public class GearSet
extends WeightedRandom.Item {
    @Expose(deserialize=false)
    protected ResourceLocation id;
    protected final List<WeightedItemStack> mainhands;
    protected final List<WeightedItemStack> offhands;
    protected final List<WeightedItemStack> boots;
    protected final List<WeightedItemStack> leggings;
    protected final List<WeightedItemStack> chestplates;
    protected final List<WeightedItemStack> helmets;
    protected final List<String> tags = new ArrayList<String>();

    public GearSet(int weight, List<WeightedItemStack> mainhands, List<WeightedItemStack> offhands, List<WeightedItemStack> boots, List<WeightedItemStack> leggings, List<WeightedItemStack> chestplates, List<WeightedItemStack> helmets) {
        super(weight);
        this.mainhands = mainhands;
        this.offhands = offhands;
        this.boots = boots;
        this.leggings = leggings;
        this.chestplates = chestplates;
        this.helmets = helmets;
    }

    public void setId(ResourceLocation id) {
        if (this.id != null) {
            throw new IllegalStateException("Cannot set the id of this boss item, it is already set!");
        }
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public LivingEntity apply(LivingEntity entity) {
        entity.func_184201_a(EquipmentSlotType.MAINHAND, GearSet.getRandomStack(this.mainhands, entity.field_70146_Z));
        entity.func_184201_a(EquipmentSlotType.OFFHAND, GearSet.getRandomStack(this.offhands, entity.field_70146_Z));
        entity.func_184201_a(EquipmentSlotType.FEET, GearSet.getRandomStack(this.boots, entity.field_70146_Z));
        entity.func_184201_a(EquipmentSlotType.LEGS, GearSet.getRandomStack(this.leggings, entity.field_70146_Z));
        entity.func_184201_a(EquipmentSlotType.CHEST, GearSet.getRandomStack(this.chestplates, entity.field_70146_Z));
        entity.func_184201_a(EquipmentSlotType.HEAD, GearSet.getRandomStack(this.helmets, entity.field_70146_Z));
        return entity;
    }

    public static ItemStack getRandomStack(List<WeightedItemStack> stacks, Random random) {
        if (stacks.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ((WeightedItemStack)WeightedRandom.func_76271_a((Random)random, stacks)).getStack().func_77946_l();
    }

    public static class SetPredicateAdapter
    implements JsonDeserializer<SetPredicate>,
    JsonSerializer<SetPredicate> {
        public JsonElement serialize(SetPredicate src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.key);
        }

        public SetPredicate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new SetPredicate(json.getAsString());
        }
    }

    public static class SetPredicate
    implements Predicate<GearSet> {
        protected final String key;
        protected final Predicate<GearSet> internal;

        public SetPredicate(String key) {
            this.key = key;
            if (key.startsWith("#")) {
                String tag = key.substring(1);
                this.internal = t -> t.tags.contains(tag);
            } else {
                ResourceLocation id = new ResourceLocation(key);
                this.internal = t -> t.id.equals((Object)id);
            }
        }

        @Override
        public boolean test(GearSet t) {
            return this.internal.test(t);
        }
    }

    public static class WeightedItemStack
    extends WeightedRandom.Item {
        final ItemStack stack;

        public WeightedItemStack(ItemStack stack, int weight) {
            super(weight);
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String toString() {
            return "Stack: " + this.stack.toString() + " @ Weight: " + this.field_76292_a;
        }
    }
}

